/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.container.osgi;

import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.jar.Manifest;

/**
 * DeploymentObserver
 *
 * @author mbasovni@redhat.com
 */
public class DeploymentObserver {

    static final Logger logger = LoggerFactory.getLogger(DeploymentObserver.class.getPackage().getName());

    public void autostartBundle(@Observes AfterDeploy event) throws Exception {
        if (event.getDeployableContainer() instanceof CommonDeployableContainer) {
            CommonDeployableContainer<?> container = (CommonDeployableContainer<?>) event.getDeployableContainer();
            if (container.isAutostartBundle()) {
                Manifest manifest = new Manifest(event.getDeployment().getArchive().get("/META-INF/MANIFEST.MF").getAsset().openStream());
                OSGiMetaData metadata = OSGiMetaDataBuilder.load(manifest);
                if (metadata.getFragmentHost() == null) {
                    container.startBundle(metadata.getBundleSymbolicName(), metadata.getBundleVersion().toString());
                } else {
                    logger.debug("Fragment bundle cannot be started");
                }
            }
        }
    }
}
