/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.osgi.bundle.ArquillianFragmentGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public abstract class AbstractOSGiApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    @Inject
    private Instance<ServiceLoader> _serviceLoaderInstance;
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String FRAGMENT_PATH = "deployment/fragment.jar";

    public void process(Archive<?> appArchive, TestClass testClass) {
        Manifest manifest = this.getBundleManifest(appArchive);
        if (manifest == null) {
            manifest = this.createBundleManifest(appArchive.getName());
        }
        if (manifest != null) {
            this.enhanceApplicationArchive(appArchive, testClass, manifest);
            this.assertValidBundleArchive(appArchive);
        }
    }

    protected abstract Manifest createBundleManifest(String var1);

    private void enhanceApplicationArchive(Archive<?> appArchive, TestClass testClass, Manifest manifest) {
        if (!ClassContainer.class.isAssignableFrom(appArchive.getClass())) {
            throw new IllegalArgumentException("ClassContainer expected: " + appArchive);
        }
        ServiceLoader serviceLoader = (ServiceLoader)this._serviceLoaderInstance.get();
        ArquillianFragmentGenerator arquillianFragmentGenerator = (ArquillianFragmentGenerator)serviceLoader.onlyOne(ArquillianFragmentGenerator.class);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayAsset byteArrayAsset = new ByteArrayAsset(baos.toByteArray());
            appArchive.delete(MANIFEST_PATH);
            appArchive.add((Asset)byteArrayAsset, MANIFEST_PATH);
            Archive arquillianFragment = arquillianFragmentGenerator.createArquillianFragment(manifest.getMainAttributes().getValue("Bundle-SymbolicName"), manifest.getMainAttributes().getValue("Bundle-Version"), testClass);
            ZipExporter arquillianBundleArchiveZipExporter = (ZipExporter)arquillianFragment.as(ZipExporter.class);
            InputStream arquillianBundleArchiveInputStream = arquillianBundleArchiveZipExporter.exportAsInputStream();
            byteArrayAsset = new ByteArrayAsset(arquillianBundleArchiveInputStream);
            appArchive.add((Asset)byteArrayAsset, FRAGMENT_PATH);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create the Arquillian Fragment", e);
        }
    }

    private void assertValidBundleArchive(Archive<?> archive) {
        try {
            Manifest manifest = this.getBundleManifest(archive);
            OSGiManifestBuilder.validateBundleManifest((Manifest)manifest);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private Manifest getBundleManifest(Archive<?> archive) {
        try {
            Node node = archive.get(MANIFEST_PATH);
            if (node == null) {
                return null;
            }
            Manifest manifest = new Manifest(node.getAsset().openStream());
            return manifest;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] splitWithComma(String value) {
        return value.split("(?x)       ,          (?=          (?:          [^\"]*     \"         [^\"]*     \"       )*         [^\"]*     $        )          ");
    }
}

