/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.util.jar.Manifest;
import org.jboss.arquillian.container.osgi.CommonDeployableContainer;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.osgi.bundle.ArquillianBundleGenerator;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentObserver {
    static final Logger logger = LoggerFactory.getLogger((String)DeploymentObserver.class.getPackage().getName());
    private CommonDeployableContainer<?> container;
    private Archive<?> _arquillianOSGiBundle;
    private long _arquillianOSGiBundleId;
    @Inject
    private Instance<ServiceLoader> _serviceLoaderInstance;

    public void buildArquillianOSGiBundle(@Observes BeforeSetup event) throws Exception {
        if (this._arquillianOSGiBundle == null) {
            ServiceLoader serviceLoader = (ServiceLoader)this._serviceLoaderInstance.get();
            ArquillianBundleGenerator arquillianBundleGenerator = (ArquillianBundleGenerator)serviceLoader.onlyOne(ArquillianBundleGenerator.class);
            this._arquillianOSGiBundle = arquillianBundleGenerator.createArquillianBundle();
        }
    }

    public void startContainer(@Observes AfterStart event) throws Exception {
        if (event.getDeployableContainer() instanceof CommonDeployableContainer) {
            this.container = (CommonDeployableContainer)event.getDeployableContainer();
        }
    }

    public void installArquillianBundle(@Observes Before event) throws Exception {
        this._arquillianOSGiBundleId = this.container.installBundle(this._arquillianOSGiBundle, true);
    }

    public void uninstallArquillianBundle(@Observes After event) throws Exception {
        this.container.uninstallBundle(this._arquillianOSGiBundleId);
        this.container.refresh();
    }

    public void autostartBundle(@Observes AfterDeploy event) throws Exception {
        CommonDeployableContainer container;
        if (event.getDeployableContainer() instanceof CommonDeployableContainer && (container = (CommonDeployableContainer)event.getDeployableContainer()).isAutostartBundle()) {
            Manifest manifest = new Manifest(event.getDeployment().getArchive().get("/META-INF/MANIFEST.MF").getAsset().openStream());
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            if (metadata.getFragmentHost() == null) {
                container.startBundle(metadata.getBundleSymbolicName(), metadata.getBundleVersion().toString());
            } else {
                logger.debug("Fragment bundle cannot be started");
            }
        }
    }
}

