/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.client.deployment;

import junit.framework.Assert;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.cdi.beans.BeansDescriptor;
import org.junit.Test;

public class DeploymentScenarioTestCase {
    @Test
    public void shouldDefaultToSingleArchive() {
        DeploymentDescription deployment = new DeploymentDescription("_DEFAULT_", (Archive)ShrinkWrap.create(JavaArchive.class));
        deployment.setTarget(TargetDescription.DEFAULT);
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(deployment);
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((Object)deployment, (Object)defaultDeployment);
    }

    @Test
    public void shouldDefaultToSingleDescriptor() {
        DeploymentDescription deployment = new DeploymentDescription("_DEFAULT_", Descriptors.create(BeansDescriptor.class));
        deployment.setTarget(TargetDescription.DEFAULT);
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(deployment);
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((Object)deployment, (Object)defaultDeployment);
    }

    @Test
    public void shouldDefaultToSingleArchiveWithDescriptor() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((String)"A", (String)defaultDeployment.getName());
    }

    @Test
    public void shouldNotDefaultWhenMultipleArchives() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        Deployment defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT);
        Assert.assertNull((Object)defaultDeployment);
    }

    @Test
    public void shouldNotDefaultWhenMultipleDescriptors() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        Deployment defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT);
        Assert.assertNull((Object)defaultDeployment);
    }

    @Test
    public void shouldNotGetDefaultWithNonDefaultName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        DeploymentDescription deployment = scenario.deployment(new DeploymentTargetDescription("B")).getDescription();
        Assert.assertEquals((String)"B", (String)deployment.getName());
    }

    @Test
    public void shouldNotGetWithUnknownName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription("C"));
        Assert.assertNull((Object)deployment);
    }
}

