/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.client.deployment;

import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.cdi.beans.BeansDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentScenarioTestCase {
    private static final String DEFAULT_NAME = DeploymentTargetDescription.DEFAULT.getName();

    @Test
    public void shouldDefaultToSingleArchive() {
        DeploymentDescription deployment = new DeploymentDescription(DEFAULT_NAME, (Archive)ShrinkWrap.create(JavaArchive.class));
        deployment.setTarget(TargetDescription.DEFAULT);
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(deployment);
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((Object)deployment, (Object)defaultDeployment);
    }

    @Test
    public void shouldDefaultToSingleDescriptor() {
        DeploymentDescription deployment = new DeploymentDescription(DEFAULT_NAME, Descriptors.create(BeansDescriptor.class));
        deployment.setTarget(TargetDescription.DEFAULT);
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(deployment);
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((Object)deployment, (Object)defaultDeployment);
    }

    @Test
    public void shouldDefaultToArchiveWhenDescriptorIsPresent() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        DeploymentDescription defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT).getDescription();
        Assert.assertEquals((Object)"A", (Object)defaultDeployment.getName());
    }

    @Test
    public void shouldNotDefaultWhenMultipleArchives() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        Deployment defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT);
        Assert.assertNull((Object)defaultDeployment);
    }

    @Test
    public void shouldDefaultToDefaultWithMultipleDeployments() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        Deployment defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT);
        Assert.assertNotNull((Object)defaultDeployment);
        Assert.assertEquals((Object)DEFAULT_NAME, (Object)defaultDeployment.getDescription().getName());
        Assert.assertTrue((boolean)defaultDeployment.getDescription().isArchiveDeployment());
    }

    @Test
    public void shouldNotDefaultWhenMultipleDescriptors() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        Deployment defaultDeployment = scenario.deployment(DeploymentTargetDescription.DEFAULT);
        Assert.assertNull((Object)defaultDeployment);
    }

    @Test
    public void shouldNotGetDefaultWithNonDefaultName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        DeploymentDescription deployment = scenario.deployment(new DeploymentTargetDescription("B")).getDescription();
        Assert.assertEquals((Object)"B", (Object)deployment.getName());
    }

    @Test
    public void shouldNotGetWithUnknownName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("B", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription("C"));
        Assert.assertNull((Object)deployment);
    }

    @Test
    public void shouldAllowMultipleDeploymentWithSameNameOfDifferentType() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("A", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription("A"));
        Assert.assertEquals((Object)"A", (Object)deployment.getDescription().getName());
        Assert.assertTrue((boolean)deployment.getDescription().isArchiveDeployment());
    }

    @Test
    public void shouldAllowMultipleDeploymentWithSameNameOfDifferentTypeOrderIrrelevant() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription("A", Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription("A", (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription("A"));
        Assert.assertEquals((Object)"A", (Object)deployment.getDescription().getName());
        Assert.assertTrue((boolean)deployment.getDescription().isArchiveDeployment());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowMultipleArchiveDeploymentsWithSameName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(TargetDescription.DEFAULT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowMultipleDescriptorDeploymentsWithSameName() {
        DeploymentScenario scenario = new DeploymentScenario();
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
        scenario.addDeployment(new DeploymentDescription(DEFAULT_NAME, Descriptors.create(BeansDescriptor.class)).setTarget(TargetDescription.DEFAULT));
    }
}

