/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.client.protocol.metadata.NamedContext;

public class JMXContext
extends NamedContext {
    private static final Logger log = Logger.getLogger(JMXContext.class.getName());
    private static Set<Reference<MBeanServerConnection>> jmxConnectorRefs = Collections.synchronizedSet(new HashSet());
    private String host;
    private int port;
    private MBeanServerConnection connection;

    public JMXContext(String host, int port) {
        this("no-named", host, port);
    }

    public JMXContext(String name, String host, int port) {
        super(name);
        this.host = host;
        this.port = port;
    }

    public JMXContext(MBeanServerConnection connection) {
        this("no-named", connection);
    }

    public JMXContext(String name, MBeanServerConnection connection) {
        super(name);
        this.connection = connection;
    }

    public MBeanServerConnection getConnection() {
        if (this.connection == null) {
            try {
                JMXConnector connector = JMXConnectorFactory.connect(this.getRemoteJMXURL(), null);
                this.connection = connector.getMBeanServerConnection();
                JMXConnectorReference ref = new JMXConnectorReference(this.connection, connector);
                jmxConnectorRefs.add(ref);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create remote JMX connection: " + this, e);
            }
        }
        return this.connection;
    }

    private JMXServiceURL getRemoteJMXURL() {
        try {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/jmxrmi");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    public String toString() {
        return "JMXContext [host=" + this.host + ", port=" + this.port + ", connection=" + this.connection + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JMXConnectorReference
    extends WeakReference<MBeanServerConnection> {
        private JMXConnector connector;

        public JMXConnectorReference(MBeanServerConnection connection, JMXConnector connector) {
            super(connection);
            this.connector = connector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean enqueue() {
            try {
                this.connector.close();
            }
            catch (Exception ignored) {
                log.warning("Could not close JMXConnector: " + this.connector);
            }
            finally {
                this.connector = null;
                jmxConnectorRefs.remove(this);
            }
            return super.enqueue();
        }
    }
}

