/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServletTest {
    private static final String TEST_SERVLET_NAME = "jsp";
    private static final String TEST_CONTEXT_ROOT = "/test";
    private static final String ROOT_CONTEXT_ROOT_BASE_URI = "http://localhost:8888/";
    private static final String TEST_CONTEXT_ROOT_BASE_URI = "http://localhost:8888//test/";
    private static final HTTPContext TEST_HTTP_CONTEXT = new HTTPContext("localhost", 8888);
    private static Servlet servlet;
    private static Servlet servletWithParent;
    private static Servlet rootContextServletWithParent;

    @BeforeClass
    public static void before() {
        servlet = new Servlet(TEST_SERVLET_NAME, TEST_CONTEXT_ROOT);
        servletWithParent = new Servlet(TEST_SERVLET_NAME, TEST_CONTEXT_ROOT);
        servletWithParent.setParent(TEST_HTTP_CONTEXT);
        rootContextServletWithParent = new Servlet(TEST_SERVLET_NAME, "/");
        rootContextServletWithParent.setParent(TEST_HTTP_CONTEXT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testServletForNullName() {
        new Servlet(null, TEST_CONTEXT_ROOT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testServletForNullContextRoot() {
        new Servlet(TEST_SERVLET_NAME, null);
    }

    @Test
    public void testGetBaseURIForTestContext() {
        String actualBaseUri = servletWithParent.getBaseURI().toString();
        Assert.assertEquals((Object)TEST_CONTEXT_ROOT_BASE_URI, (Object)actualBaseUri);
    }

    @Test
    public void testGetBaseURIForRootContext() {
        String actualBaseUri = rootContextServletWithParent.getBaseURI().toString();
        Assert.assertEquals((Object)ROOT_CONTEXT_ROOT_BASE_URI, (Object)actualBaseUri);
    }

    @Test(expected=IllegalStateException.class)
    public void testEqualsObjectForNullHost() {
        servlet.equals(null);
    }

    @Test
    public void testEqualsObjectForNonNullHost() {
        try {
            Assert.assertTrue((boolean)servletWithParent.equals((Object)servletWithParent));
        }
        catch (IllegalStateException e) {
            this.failOnUnexpectedException(e);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testHashCodeForNullHost() {
        servlet.hashCode();
    }

    @Test
    public void testHashCodeForNonNullHost() {
        try {
            servletWithParent.hashCode();
        }
        catch (IllegalStateException e) {
            this.failOnUnexpectedException(e);
        }
    }

    private void failOnUnexpectedException(Exception e) {
        Assert.fail((String)(e.getClass().getSimpleName() + " was not expected: " + e.getMessage()));
    }
}

