/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.embedded;

import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jboss.arquillian.container.appengine.embedded.AppEngineEmbeddedConfiguration;
import org.jboss.arquillian.container.appengine.embedded.AppEngineSetup;
import org.jboss.arquillian.container.appengine.embedded.WebAppContextUtil;
import org.jboss.arquillian.container.appengine.embedded.hack.AppEngineHack;
import org.jboss.arquillian.container.appengine.embedded.hack.DevAppServerFactoryHack;
import org.jboss.arquillian.container.common.AppEngineCommonContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;

public class AppEngineEmbeddedContainer
extends AppEngineCommonContainer<AppEngineEmbeddedConfiguration> {
    private AppEngineEmbeddedConfiguration containerConfig;
    private DevAppServer server;

    public Class<AppEngineEmbeddedConfiguration> getConfigurationClass() {
        return AppEngineEmbeddedConfiguration.class;
    }

    public void setup(AppEngineEmbeddedConfiguration configuration) {
        this.containerConfig = configuration;
    }

    protected void prepareArchive(Archive<?> archive) {
        AppEngineSetup.prepare(archive);
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.server = AccessController.doPrivileged(new PrivilegedExceptionAction<DevAppServer>(){

                @Override
                public DevAppServer run() throws Exception {
                    return DevAppServerFactoryHack.createDevAppServer(AppEngineEmbeddedContainer.this.getAppLocation(), AppEngineEmbeddedContainer.this.containerConfig.getBindAddress(), AppEngineEmbeddedContainer.this.containerConfig.getBindHttpPort());
                }
            });
            Properties properties = System.getProperties();
            this.server.setServiceProperties((Map)properties);
            this.server.start();
        }
        catch (Exception e) {
            this.server = null;
            this.deleteAppLocation();
            throw new DeploymentException("Error starting AppEngine.", (Throwable)e);
        }
        try {
            this.setup("start", this.getAppLocation(), this.containerConfig.getBindHttpPort(), this.containerConfig.getBindAddress());
        }
        catch (Exception e) {
            this.shutdownServer();
            this.deleteAppLocation();
            throw new DeploymentException("Cannot setup GAE Api Environment", (Throwable)e);
        }
        try {
            HTTPContext httpContext = new HTTPContext(this.containerConfig.getBindAddress(), this.containerConfig.getBindHttpPort());
            AppContext context = this.server.getAppContext();
            WebAppContextUtil wctx = new WebAppContextUtil(context.getContainerContext());
            for (WebAppContextUtil.ServletHolder servletHolder : wctx.getServlets()) {
                httpContext.add(new Servlet(servletHolder.getName(), wctx.getContextPath()));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            this.teardown();
            this.shutdownServer();
            this.deleteAppLocation();
            throw new DeploymentException("Could not create ContainerMethodExecutor", (Throwable)e);
        }
    }

    private void setup(String methodName, Object ... args) throws Exception {
        AppContext appContext = this.server.getAppContext();
        ClassLoader cl = appContext.getClassLoader();
        Class<?> clazz = cl.loadClass(AppEngineHack.class.getName());
        Class[] classes = new Class[]{};
        if (args != null && args.length > 0) {
            classes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classes[i] = args[i].getClass();
            }
        }
        Method method = clazz.getMethod(methodName, classes);
        Object instance = clazz.newInstance();
        method.invoke(instance, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownServer() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error shutting down AppEngine", e);
        }
        finally {
            this.server = null;
        }
    }

    protected void teardown() {
        try {
            this.setup("stop", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

