/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.embedded;

import java.lang.reflect.Method;
import java.util.ArrayList;

class WebAppContextUtil {
    private Object context;
    private String contextPath;

    WebAppContextUtil(Object context) {
        this.context = context;
    }

    private static <T> T invoke(Object target, Class<T> clazz, String method) {
        try {
            Method m = target.getClass().getMethod(method, new Class[0]);
            return clazz.cast(m.invoke(target, new Object[0]));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    String getContextPath() {
        if (this.contextPath == null) {
            this.contextPath = WebAppContextUtil.invoke(this.context, String.class, "getContextPath");
        }
        return this.contextPath;
    }

    public Iterable<? extends ServletHolder> getServlets() {
        Object[] servlets;
        ArrayList<ServletHolder> holders = new ArrayList<ServletHolder>();
        Object holder = WebAppContextUtil.invoke(this.context, Object.class, "getServletHandler");
        for (Object servlet : servlets = WebAppContextUtil.invoke(holder, Object[].class, "getServlets")) {
            holders.add(new ServletHolder(servlet));
        }
        return holders;
    }

    public static class ServletHolder {
        private Object servlet;

        ServletHolder(Object servlet) {
            this.servlet = servlet;
        }

        String getName() {
            return (String)WebAppContextUtil.invoke(this.servlet, String.class, "getName");
        }
    }
}

