/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.local;

import java.io.File;
import java.util.ArrayList;
import org.jboss.arquillian.container.appengine.cli.AppEngineCLIContainer;
import org.jboss.arquillian.container.appengine.local.AppEngineLocalConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;

public class AppEngineLocalContainer
extends AppEngineCLIContainer<AppEngineLocalConfiguration> {
    private AppEngineLocalConfiguration configuration;

    public Class<AppEngineLocalConfiguration> getConfigurationClass() {
        return AppEngineLocalConfiguration.class;
    }

    public void setup(AppEngineLocalConfiguration configuration) {
        this.configuration = configuration;
        if (configuration.getSdkDir() == null) {
            throw new ConfigurationException("AppEngine SDK root is null.");
        }
        System.setProperty("appengine.sdk.root", configuration.getSdkDir());
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        try {
            boolean isJavaAgentSet;
            String toolsJar;
            ArrayList<String> args = new ArrayList<String>();
            args.add("com.google.appengine.tools.development.DevAppServerMain");
            String sdkDir = (String)AppEngineLocalContainer.addArg(args, (String)"sdk_root", (Object)this.configuration.getSdkDir(), (boolean)false);
            if (!new File(sdkDir).isDirectory()) {
                throw new DeploymentException("SDK root is not a directory: " + sdkDir);
            }
            String classpath = System.getProperty("java.class.path");
            if (!classpath.contains(toolsJar = sdkDir + "/lib/appengine-tools-api.jar")) {
                System.setProperty("java.class.path", classpath + File.pathSeparator + toolsJar);
            }
            AppEngineLocalContainer.addArg(args, (String)"server", (Object)this.configuration.getServer(), (boolean)true);
            AppEngineLocalContainer.addArg(args, (String)"address", (Object)this.configuration.getAddress(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"port", (Object)this.configuration.getPort(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"startOnFirstThread", (Object)this.configuration.isDisableUpdateCheck(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"disable_update_check", (boolean)this.configuration.isStartOnFirstThread());
            boolean bl = isJavaAgentSet = this.configuration.getJavaAgent() != null;
            if (isJavaAgentSet) {
                AppEngineLocalContainer.addArg(args, (String)"jvm_flag", (Object)"-noverify", (boolean)false);
                AppEngineLocalContainer.addArg(args, (String)"jvm_flag", (Object)("-javaagent:" + this.configuration.getJavaAgent()), (boolean)false);
            }
            args.add(this.getAppLocation().getCanonicalPath());
            this.invokeAppEngine(sdkDir, "com.google.appengine.tools.KickStart", args.toArray(new String[args.size()]));
            String serverURL = this.configuration.getServerTestURL();
            if (serverURL == null) {
                serverURL = "http://localhost:" + this.configuration.getPort() + "/_ah/admin";
            }
            this.delayArchiveDeploy(serverURL, this.configuration.getStartupTimeout(), 1000L);
            return AppEngineLocalContainer.getProtocolMetaData((String)this.configuration.getAddress(), (int)this.configuration.getPort(), archive);
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot deploy to local GAE.", (Throwable)e);
        }
    }
}

