/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.local;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.arquillian.container.appengine.cli.AppEngineCLIContainer;
import org.jboss.arquillian.container.appengine.local.AppEngineLocalConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;

public class AppEngineLocalContainer
extends AppEngineCLIContainer<AppEngineLocalConfiguration> {
    private static final String JVM_FLAG = "jvm_flag";
    private static final String APPENGINE_TEST = "appengine.test.";
    private AppEngineLocalConfiguration configuration;

    public Class<AppEngineLocalConfiguration> getConfigurationClass() {
        return AppEngineLocalConfiguration.class;
    }

    public void setup(AppEngineLocalConfiguration configuration) {
        this.configuration = configuration;
        if (configuration.getSdkDir() == null) {
            throw new ConfigurationException("AppEngine SDK root is null.");
        }
        System.setProperty("appengine.sdk.root", configuration.getSdkDir());
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        String classpath = System.getProperty("java.class.path");
        try {
            boolean isJavaAgentSet;
            ArrayList<String> args = new ArrayList<String>();
            args.add("com.google.appengine.tools.development.DevAppServerMain");
            String sdkDir = (String)AppEngineLocalContainer.addArg(args, (String)"sdk_root", (Object)this.configuration.getSdkDir(), (boolean)false);
            if (!new File(sdkDir).isDirectory()) {
                throw new DeploymentException("SDK root is not a directory: " + sdkDir);
            }
            String toolsJar = sdkDir + "/lib/appengine-tools-api.jar";
            if (!new File(toolsJar).exists()) {
                throw new DeploymentException("No appengine-tools-api.jar: " + toolsJar);
            }
            System.setProperty("java.class.path", toolsJar);
            AppEngineLocalContainer.addArg(args, (String)"server", (Object)this.configuration.getServer(), (boolean)true);
            AppEngineLocalContainer.addArg(args, (String)"address", (Object)this.configuration.getAddress(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"port", (Object)this.configuration.getPort(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"startOnFirstThread", (Object)this.configuration.isDisableUpdateCheck(), (boolean)false);
            AppEngineLocalContainer.addArg(args, (String)"disable_update_check", (boolean)this.configuration.isStartOnFirstThread());
            boolean bl = isJavaAgentSet = this.configuration.getJavaAgent() != null;
            if (isJavaAgentSet) {
                AppEngineLocalContainer.jvm_flag(args, "-noverify");
                AppEngineLocalContainer.jvm_flag(args, "-javaagent:" + this.configuration.getJavaAgent());
            }
            Properties properties = System.getProperties();
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith(APPENGINE_TEST)) continue;
                AppEngineLocalContainer.jvm_flag(args, "-D" + key.substring(APPENGINE_TEST.length()) + "=" + properties.getProperty(key));
            }
            args.add(this.getAppLocation().getCanonicalPath());
            this.invokeAppEngine(sdkDir, "com.google.appengine.tools.KickStart", args.toArray(new String[args.size()]));
            String serverURL = this.configuration.getServerTestURL();
            if (serverURL == null) {
                serverURL = "http://localhost:" + this.configuration.getPort() + "/_ah/admin";
            }
            this.delayArchiveDeploy(serverURL, this.configuration.getStartupTimeout(), 1000L);
            ProtocolMetaData protocolMetaData = this.getProtocolMetaData(this.configuration.getAddress(), this.configuration.getPort(), archive);
            return protocolMetaData;
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot deploy to local GAE.", (Throwable)e);
        }
        finally {
            System.setProperty("java.class.path", classpath);
        }
    }

    protected static void jvm_flag(List<String> args, String value) {
        AppEngineLocalContainer.addArg(args, (String)JVM_FLAG, (Object)value, (boolean)false);
    }
}

