/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other
 * contributors as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.arquillian.container.appengine.tools;


import org.jboss.arquillian.container.common.AppEngineCommonConfiguration;

/**
 * AppEngine CLI configuration.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class AppEngineToolsConfiguration extends AppEngineCommonConfiguration {
    private boolean updateCheck;
    private int port = 80;
    private long startupTimeout = 60 * 1000L; // 60sec
    private String userId = System.getProperty(PREFIX + "userId");
    private String password = System.getProperty(PREFIX + "password"); // TODO better?
    private String appId = System.getProperty(PREFIX + "appId");
    private String module = System.getProperty(PREFIX + "module");

    // [null]: use userId/password
    // [blank]: use access_token in ${HOME}/appcfg_oauth2_tokens_java
    // [has_string]: use as the access token.
    private String oauth2token = System.getProperty(PREFIX + "oauth2token");

    // This server is the app under test.
    // See AppEngineToolsContainer.java for the APPENGINE_SERVER environment setting used to
    // upload the app.
    private String server = System.getProperty(PREFIX + "server"); //

    public boolean isUpdateCheck() {
        return updateCheck;
    }

    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getStartupTimeout() {
        return startupTimeout;
    }

    public void setStartupTimeout(long startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setOauth2token(String token) {
        this.oauth2token = token;
    }

    public String getOauth2token() {
        return this.oauth2token;
    }
}
