/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.tools;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.OAuth2Native;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.appengine.tools.AppEngineToolsConfiguration;
import org.jboss.arquillian.container.appengine.tools.Status;
import org.jboss.arquillian.container.common.AppEngineCommonContainer;
import org.jboss.arquillian.container.common.ParseUtils;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.application5.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.application5.ModuleType;
import org.xml.sax.SAXParseException;

public class AppEngineToolsContainer
extends AppEngineCommonContainer<AppEngineToolsConfiguration> {
    private AppEngineToolsConfiguration configuration;
    private Map<String, String> modules = new LinkedHashMap<String, String>();

    public Class<AppEngineToolsConfiguration> getConfigurationClass() {
        return AppEngineToolsConfiguration.class;
    }

    public void setup(AppEngineToolsConfiguration configuration) {
        String sdkDir = configuration.getSdkDir();
        if (sdkDir == null) {
            throw new ConfigurationException("AppEngine SDK root is null.");
        }
        if (configuration.getOauth2token() == null) {
            String userId = configuration.getUserId();
            if (userId == null) {
                throw new ConfigurationException("Null userId.");
            }
            String password = configuration.getPassword();
            if (password == null) {
                throw new ConfigurationException("Null password.");
            }
        }
        SdkInfo.setSdkRoot((File)new File(sdkDir));
        this.configuration = configuration;
    }

    protected File export(Archive<?> archive) throws Exception {
        if (archive instanceof WebArchive) {
            this.modules.put(AppEngineToolsContainer.parseModule((WebArchive)((WebArchive)WebArchive.class.cast(archive))), "");
            return super.export(archive);
        }
        if (archive instanceof EnterpriseArchive) {
            return this.rearrangeEar((EnterpriseArchive)EnterpriseArchive.class.cast(archive));
        }
        throw new IllegalArgumentException("Can only handle .war or .ear deployments: " + archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File rearrangeEar(EnterpriseArchive ear) {
        File root = this.getTempRoot();
        Node appXml = ear.get("META-INF/application.xml");
        if (appXml != null) {
            InputStream stream = appXml.getAsset().openStream();
            try {
                Node lib;
                ApplicationDescriptor ad = (ApplicationDescriptor)Descriptors.importAs(ApplicationDescriptor.class).fromStream(stream);
                ArrayList<JavaArchive> libs = new ArrayList<JavaArchive>();
                String libDir = ad.getLibraryDirectory();
                if (libDir != null) {
                    libDir = "lib";
                }
                if ((lib = ear.get(libDir)) != null) {
                    HashSet children = new HashSet(lib.getChildren());
                    for (Node child : children) {
                        if (!child.getPath().get().endsWith(".jar")) continue;
                        JavaArchive jar = (JavaArchive)ear.getAsType(JavaArchive.class, child.getPath());
                        libs.add(jar);
                    }
                }
                List allModules = ad.getAllModule();
                for (ModuleType mt : allModules) {
                    String uri = mt.getOrCreateWeb().getWebUri();
                    if (uri != null) {
                        WebArchive war = (WebArchive)ear.getAsType(WebArchive.class, uri);
                        this.handleWar(root, libs, war, uri);
                        continue;
                    }
                    mt.removeWeb();
                }
            }
            finally {
                AppEngineToolsContainer.safeClose((Closeable)stream);
            }
        }
        return root;
    }

    private void handleWar(File root, List<JavaArchive> libs, WebArchive war, String uri) {
        try {
            String module = AppEngineToolsContainer.parseModule((WebArchive)war);
            if (this.modules.put(module, uri) != null) {
                throw new IllegalArgumentException(String.format("Duplicate module %s in %s", module, this.modules));
            }
            this.log.info(String.format("Found %s module in web archive %s", module, war.getName()));
            WebArchive copy = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)war.getName());
            copy.merge((Archive)war);
            copy.addAsLibraries(libs);
            this.export((Archive)copy, root);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        try {
            ProtocolMetaData protocolMetaData = this.doDeployInternal(archive);
            return protocolMetaData;
        }
        finally {
            this.modules.clear();
        }
    }

    protected ProtocolMetaData doDeployInternal(Archive<?> archive) throws DeploymentException {
        UpdateCheck updateCheck;
        if (this.configuration.isUpdateCheck() && (updateCheck = new UpdateCheck(SdkInfo.getDefaultServer())).allowedToCheckForUpdates()) {
            updateCheck.maybePrintNagScreen(new PrintStream(System.out, true));
        }
        String appId = this.configuration.getAppId();
        String module = this.configuration.getModule();
        if (archive instanceof WebArchive) {
            Application app = this.readApplication("");
            if (appId != null) {
                app.getAppEngineWebXml().setAppId(appId);
            } else if (appId == null) {
                appId = app.getAppEngineWebXml().getAppId();
            }
            if (module != null) {
                app.getAppEngineWebXml().setModule(module);
            }
            this.handleApp(app);
        } else if (archive instanceof EnterpriseArchive) {
            EnterpriseArchive ear = (EnterpriseArchive)EnterpriseArchive.class.cast(archive);
            if (appId == null) {
                Node aaXml = ear.get("META-INF/appengine-application.xml");
                if (aaXml == null) {
                    throw new IllegalArgumentException("Missing appengine-application.xml: " + ear);
                }
                try {
                    Map map = ParseUtils.parseTokens((Node)aaXml, (String[])new String[]{"<application>"});
                    appId = (String)map.get("<application>");
                }
                catch (Exception exception) {
                    throw new DeploymentException(exception.getMessage());
                }
            }
            if (module != null) {
                String war = this.modules.get(module);
                if (war == null) {
                    throw new IllegalArgumentException(String.format("No such module %s in %s", module, this.modules));
                }
                Application application = this.readApplication(war);
                if (appId != null) {
                    application.getAppEngineWebXml().setAppId(appId);
                }
                application.getAppEngineWebXml().setModule(module);
                this.handleApp(application);
            } else {
                for (Map.Entry entry : this.modules.entrySet()) {
                    Application app = this.readApplication((String)entry.getValue());
                    if (appId != null) {
                        app.getAppEngineWebXml().setAppId(appId);
                    }
                    this.handleApp(app);
                }
            }
        }
        String server = this.configuration.getServer();
        if (server == null) {
            server = "appspot.com";
        }
        String host = appId + "." + server;
        if (module == null) {
            String[] stringArray = this.modules.keySet().toArray(new String[this.modules.size()]);
            return this.getProtocolMetaData(host, this.configuration.getPort(), stringArray);
        }
        return this.getProtocolMetaData(host, this.configuration.getPort(), new String[]{module});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleApp(Application app) throws DeploymentException {
        try {
            Status status;
            final AppAdmin appAdmin = this.createAppAdmin(app);
            final DeployUpdateListener listener = new DeployUpdateListener((Object)this, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    appAdmin.update((UpdateListener)listener);
                }
            });
            AppEngineToolsContainer appEngineToolsContainer = this;
            synchronized (appEngineToolsContainer) {
                do {
                    ((Object)((Object)this)).wait(this.configuration.getStartupTimeout());
                } while ((status = listener.getStatus()) == null);
            }
            if (status != Status.OK) {
                throw new DeploymentException("Cannot deploy via GAE tools: " + (Object)((Object)status));
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (AppEngineConfigException e) {
            if (e.getCause() instanceof SAXParseException) {
                String msg = e.getCause().getMessage();
                if (msg.contains("Failed to read schema document") && msg.contains("backends.xsd")) {
                    throw new IllegalArgumentException("Deploying a project with backends requires App Engine SDK 1.5.0 or greater.", e);
                }
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new DeploymentException("Cannot deploy via GAE tools.", (Throwable)e);
        }
    }

    protected Executor getExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    protected Application readApplication(String path) {
        try {
            File app = this.getAppLocation();
            if (path != null && path.trim().length() > 0) {
                app = new File(app, path);
            }
            return Application.readApplication((String)app.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getOAuthToken() {
        String runOauth2Msg = "Create ${HOME}/.appcfg_oauth2_tokens by running $appcfg.sh --oauth2 update YOUR-WAR-DIR";
        String userDir = System.getProperty("user.home");
        File tokenFile = new File(userDir, ".appcfg_oauth2_tokens_java");
        if (!tokenFile.exists()) {
            throw new ConfigurationException(runOauth2Msg);
        }
        boolean useCookies = true;
        String oauth2ClientId = null;
        String oauth2ClientSecret = null;
        String oauth2RefreshToken = null;
        OAuth2Native client = new OAuth2Native(useCookies, oauth2ClientId, oauth2ClientSecret, oauth2RefreshToken);
        Credential credential = client.authorize();
        if (credential == null || credential.getAccessToken() == null) {
            String errMsg = "Tokens expired? " + runOauth2Msg;
            throw new ConfigurationException(errMsg);
        }
        return credential.getAccessToken();
    }

    AppAdmin createAppAdmin(Application app) throws IOException {
        AppAdminFactory appAdminFactory = new AppAdminFactory();
        AppAdminFactory.ConnectOptions appEngineConnectOptions = new AppAdminFactory.ConnectOptions();
        String appengineServer = System.getenv("APPENGINE_SERVER");
        if (appengineServer != null) {
            appEngineConnectOptions.setServer(appengineServer);
        }
        appEngineConnectOptions.setUserId(this.configuration.getUserId());
        appEngineConnectOptions.setPasswordPrompt(new AppAdminFactory.PasswordPrompt(){

            public String getPassword() {
                return AppEngineToolsContainer.this.configuration.getPassword();
            }
        });
        String oauthToken = null;
        String configOauthToken = this.configuration.getOauth2token();
        if (configOauthToken != null) {
            oauthToken = configOauthToken.trim().equals("") ? this.getOAuthToken() : configOauthToken;
        }
        appEngineConnectOptions.setOauthToken(oauthToken);
        PrintWriter errorWriter = new PrintWriter(System.err, true);
        return appAdminFactory.createAppAdmin(appEngineConnectOptions, app, errorWriter);
    }

    private static final class DeployUpdateListener
    implements UpdateListener {
        private static final Logger log = Logger.getLogger(DeployUpdateListener.class.getName());
        private final Object waiter;
        private final PrintWriter errorWriter;
        private final PrintWriter outputWriter;
        private MessageHeaders messageHeaders;
        private int percentDone = 0;
        private Status status = null;

        private static String getDetailsIfSupported(Object updateEvent) {
            try {
                Method method = updateEvent.getClass().getDeclaredMethod("getDetails", new Class[0]);
                return (String)method.invoke(updateEvent, new Object[0]);
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }

        private static boolean isJspCompilationException(Throwable ex) {
            if (ex != null) {
                try {
                    Class<?> jspCompilationExceptionClass = Class.forName("com.google.appengine.tools.admin.JspCompilationException");
                    return jspCompilationExceptionClass.isAssignableFrom(ex.getClass());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }

        private DeployUpdateListener(Object waiter, PrintWriter outputWriter, PrintWriter errorWriter) {
            this.waiter = waiter;
            this.outputWriter = outputWriter;
            this.errorWriter = errorWriter;
            this.messageHeaders = new MessageHeaders();
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(UpdateFailureEvent event) {
            String details;
            this.status = Status.ERROR;
            this.outputWriter.println(event.getFailureMessage());
            if (DeployUpdateListener.isJspCompilationException(event.getCause()) && (details = DeployUpdateListener.getDetailsIfSupported(event)) != null) {
                this.outputWriter.println(details);
            }
            Object object = this.waiter;
            synchronized (object) {
                this.waiter.notify();
            }
        }

        public void onProgress(UpdateProgressEvent event) {
            int worked = event.getPercentageComplete() - this.percentDone;
            this.percentDone += worked;
            String msg = event.getMessage();
            PrefixHeaderPair php = this.messageHeaders.getMessageHeader(msg);
            if (php != null) {
                this.outputWriter.println("\n" + php.header + ":");
            }
            this.outputWriter.println("\t" + msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(UpdateSuccessEvent event) {
            this.status = Status.OK;
            this.percentDone = 0;
            String details = DeployUpdateListener.getDetailsIfSupported(event);
            if (details != null) {
                this.errorWriter.println(details);
            }
            this.outputWriter.println("\nDeployment completed successfully");
            Object object = this.waiter;
            synchronized (object) {
                this.waiter.notify();
            }
        }

        public void println(String s) {
            this.outputWriter.println(s);
        }

        private static class PrefixHeaderPair {
            final String header;
            final String[] msgPrefixes;
            final String taskHeader;

            PrefixHeaderPair(String header, String taskHeader, String ... msgPrefixes) {
                this.msgPrefixes = msgPrefixes;
                this.header = header;
                this.taskHeader = taskHeader == null ? header : taskHeader;
            }
        }

        private static class MessageHeaders {
            private static final PrefixHeaderPair[] prefixHeaderPairs = new PrefixHeaderPair[]{new PrefixHeaderPair("Preparing to deploy", null, "Created staging directory", "Scanning files on local disk"), new PrefixHeaderPair("Deploying", null, "Uploading"), new PrefixHeaderPair("Verifying availability", "Verifying availability of", "Will check again in 1 seconds."), new PrefixHeaderPair("Updating datastore", null, "Uploading index")};
            private int currentPrefixHeaderPair;

            private MessageHeaders() {
            }

            PrefixHeaderPair getMessageHeader(String msg) {
                PrefixHeaderPair php = prefixHeaderPairs[this.currentPrefixHeaderPair];
                for (String prefix : php.msgPrefixes) {
                    if (!msg.startsWith(prefix)) continue;
                    this.currentPrefixHeaderPair = (this.currentPrefixHeaderPair + 1) % prefixHeaderPairs.length;
                    return php;
                }
                return null;
            }
        }
    }
}

