/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClient;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientException;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientService;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonGlassFishManager<C extends CommonGlassFishConfiguration> {
    private static final Logger log = Logger.getLogger(CommonGlassFishManager.class.getName());
    private static final String DELETE_OPERATION = "__deleteoperation";
    private C configuration;
    private GlassFishClient glassFishClient;
    private String deploymentName;

    public CommonGlassFishManager(C configuration) {
        this.configuration = configuration;
        this.glassFishClient = new GlassFishClientService((CommonGlassFishConfiguration)configuration);
    }

    public void start() throws LifecycleException {
        try {
            this.glassFishClient.startUp();
        }
        catch (GlassFishClientException e) {
            log.severe(e.getMessage());
            throw new LifecycleException(e.getMessage());
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        String archiveName = archive.getName();
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        try {
            InputStream deployment = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            FormDataMultiPart form = new FormDataMultiPart();
            form.bodyPart((BodyPart)new StreamDataBodyPart("id", deployment, archiveName));
            this.deploymentName = this.createDeploymentName(archiveName);
            this.addDeployFormFields(this.deploymentName, form);
            HTTPContext httpContext = this.glassFishClient.doDeploy(this.deploymentName, form);
            protocolMetaData.addContext((Object)httpContext);
        }
        catch (GlassFishClientException e) {
            throw new DeploymentException("Could not deploy " + archiveName, (Throwable)e);
        }
        return protocolMetaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must not be null");
        }
        this.deploymentName = this.createDeploymentName(archive.getName());
        try {
            FormDataMultiPart form = new FormDataMultiPart();
            form.field("target", (Object)((CommonGlassFishConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
            form.field("operation", (Object)DELETE_OPERATION, MediaType.TEXT_PLAIN_TYPE);
            this.glassFishClient.doUndeploy(this.deploymentName, form);
        }
        catch (GlassFishClientException e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public boolean isDASRunning() {
        return this.glassFishClient.isDASRunning();
    }

    private String createDeploymentName(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private void addDeployFormFields(String name, FormDataMultiPart deployform) {
        deployform.field("name", (Object)name, MediaType.TEXT_PLAIN_TYPE);
        deployform.field("target", (Object)((CommonGlassFishConfiguration)this.configuration).getTarget(), MediaType.TEXT_PLAIN_TYPE);
        if (((CommonGlassFishConfiguration)this.configuration).getLibraries() != null) {
            deployform.field("libraries", (Object)((CommonGlassFishConfiguration)this.configuration).getLibraries(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonGlassFishConfiguration)this.configuration).getProperties() != null) {
            deployform.field("properties", (Object)((CommonGlassFishConfiguration)this.configuration).getProperties(), MediaType.TEXT_PLAIN_TYPE);
        }
        if (((CommonGlassFishConfiguration)this.configuration).getType() != null && "osgi".equals(((CommonGlassFishConfiguration)this.configuration).getType())) {
            deployform.field("type", (Object)((CommonGlassFishConfiguration)this.configuration).getType(), MediaType.TEXT_PLAIN_TYPE);
        }
    }
}

