/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.clientutils;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.CsrfProtectionFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishClientUtil {
    public static final String SUCCESS = "SUCCESS";
    public static final String WARNING = "WARNING";
    private CommonGlassFishConfiguration configuration;
    private String adminBaseUrl;
    private static final Logger log = Logger.getLogger(GlassFishClientUtil.class.getName());

    public GlassFishClientUtil(CommonGlassFishConfiguration configuration, String adminBaseUrl) {
        this.configuration = configuration;
        this.adminBaseUrl = adminBaseUrl;
    }

    public CommonGlassFishConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getAttributes(String additionalResourceUrl) {
        Map responseMap = this.GETRequest(additionalResourceUrl);
        Map<String, String> attributes = new HashMap<String, String>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            attributes = (Map)resultExtraProperties.get("entity");
        }
        return attributes;
    }

    public Map<String, String> getChildResources(String additionalResourceUrl) throws ContainerException {
        Map responseMap = this.GETRequest(additionalResourceUrl);
        Map<String, String> childResources = new HashMap<String, String>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            childResources = (Map)resultExtraProperties.get("childResources");
        }
        return childResources;
    }

    public Map GETRequest(String additionalResourceUrl) {
        ClientResponse response = (ClientResponse)this.prepareClient(additionalResourceUrl).get(ClientResponse.class);
        Map responseMap = this.getResponseMap(response);
        return responseMap;
    }

    public List<Map> getInstancesList(String additionalResourceUrl) throws ContainerException {
        Map responseMap = this.GETRequest(additionalResourceUrl);
        List instancesList = new ArrayList<Map>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            instancesList = (List)resultExtraProperties.get("instanceList");
        }
        return instancesList;
    }

    public Map POSTMultiPartRequest(String additionalResourceUrl, FormDataMultiPart form) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.prepareClient(additionalResourceUrl).type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)form);
        Map responseMap = this.getResponseMap(response);
        return responseMap;
    }

    private WebResource.Builder prepareClient(String additionalResourceUrl) {
        Client client = Client.create();
        if (this.configuration.isAuthorisation()) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.configuration.getAdminUser(), this.configuration.getAdminPassword()));
        }
        client.addFilter((ClientFilter)new CsrfProtectionFilter());
        return (WebResource.Builder)client.resource(this.adminBaseUrl + additionalResourceUrl).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("X-GlassFish-3", (Object)"ignore");
    }

    private Map getResponseMap(ClientResponse response) throws ContainerException {
        ClientResponse.Status status;
        Map responseMap = new HashMap();
        String message = "";
        String xmlDoc = (String)response.getEntity(String.class);
        if (xmlDoc != null && !xmlDoc.isEmpty()) {
            responseMap = this.xmlToMap(xmlDoc);
            message = "exit_code: " + responseMap.get("exit_code") + ", message: " + responseMap.get("message");
        }
        if ((status = ClientResponse.Status.fromStatusCode((int)response.getStatus())).getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (responseMap.get("exit_code") == null) {
                throw new GlassFishClientException(message);
            }
            if (WARNING.equals(responseMap.get("exit_code"))) {
                log.warning("Deployment resulted in a warning: " + message);
            } else if (!SUCCESS.equals(responseMap.get("exit_code"))) {
                throw new GlassFishClientException(message);
            }
        } else if (status.getReasonPhrase() == "Not Found") {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.warning(message);
        } else {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.severe(message);
            throw new ContainerException(message);
        }
        return responseMap;
    }

    public Map xmlToMap(String document) {
        if (document == null) {
            return new HashMap();
        }
        InputStream input = null;
        Map map = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", false);
            input = new ByteArrayInputStream(document.trim().getBytes("UTF-8"));
            XMLStreamReader stream = factory.createXMLStreamReader(input);
            while (stream.hasNext()) {
                int currentEvent = stream.next();
                if (currentEvent != 1 || !"map".equals(stream.getLocalName())) continue;
                map = this.resolveXmlMap(stream);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        return map;
    }

    private Map resolveXmlMap(XMLStreamReader stream) throws XMLStreamException {
        boolean endMapFlag = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String elementName = null;
        while (!endMapFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                Object value;
                if ("entry".equals(stream.getLocalName())) {
                    key = stream.getAttributeValue(null, "key");
                    value = stream.getAttributeValue(null, "value");
                    if (value == null) continue;
                    entry.put(key, value);
                    key = null;
                    continue;
                }
                if ("map".equals(stream.getLocalName())) {
                    value = this.resolveXmlMap(stream);
                    entry.put(key, value);
                    continue;
                }
                if ("list".equals(stream.getLocalName())) {
                    value = this.resolveXmlList(stream);
                    entry.put(key, value);
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("map".equals(stream.getLocalName())) {
                    endMapFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    entry.put(key, Double.parseDouble(document));
                } else {
                    entry.put(key, Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                entry.put(key, document);
            }
            elementName = null;
        }
        return entry;
    }

    private List resolveXmlList(XMLStreamReader stream) throws XMLStreamException {
        boolean endListFlag = false;
        ArrayList<Object> list = new ArrayList<Object>();
        String elementName = null;
        while (!endListFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                if ("map".equals(stream.getLocalName())) {
                    list.add(this.resolveXmlMap(stream));
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("list".equals(stream.getLocalName())) {
                    endListFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    list.add(Double.parseDouble(document));
                } else {
                    list.add(Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                list.add(document);
            }
            elementName = null;
        }
        return list;
    }
}

