/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.clientutils;

import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClient;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientException;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientUtil;
import org.jboss.arquillian.container.glassfish.clientutils.NodeAddress;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;

public class GlassFishClientService
implements GlassFishClient {
    private static final String WEBMODULE = "WebModule";
    private static final String SERVLET = "Servlet";
    private static final String RUNNING_STATUS = "RUNNING";
    public static final String USER_AGENT_VALUE = "arquillian-glassfish-managed-6";
    private String target;
    private String adminBaseUrl;
    private String DASUrl;
    CommonGlassFishConfiguration configuration;
    private ServerStartegy serverInstance = null;
    private GlassFishClientUtil clientUtil;
    private NodeAddress nodeAddress = null;
    private int majorVersion = 6;
    private int minorVersion;
    private static final Logger log = Logger.getLogger(GlassFishClientService.class.getName());
    private static final String GLASSFISH_VERSION = "/version";
    private static final String INSTACE_LIST = "/list-instances";
    private static final String APPLICATION = "/applications/application";
    private static final String APPLICATION_RESOURCE = "/applications/application/{name}";
    private static final String STANALONE_SERVER_INSTACES = "/servers/server";
    private static final String CLUSTERED_SERVER_INSTACES = "/clusters/cluster";
    private static final String MEMBER_SERVERS_RESOURCE = "/clusters/cluster/{target}/server-ref";
    private static final String SERVER_RESOURCE = "/servers/server/{server}";
    private static final String CLUSTER_RESOURCE = "/clusters/cluster/{cluster}";
    private static final String NODE_RESOURCE = "/nodes/node/{node}";
    private static final String SYSTEM_PROPERTY = "/configs/config/{config}/system-property/{system-property}";
    private static final String SERVER_PROPERTY = "/servers/server/{server}/system-property/{system-property}";
    private static final String HTTP_LISTENER_INS = "/servers/server/{server}/system-property/{http-listener}";
    private static final String VIRTUAL_SERVERS = "/configs/config/{config}/http-service/list-virtual-servers";
    private static final String VIRTUAL_SERVER = "/configs/config/{config}/http-service/virtual-server/{virtualServer}";
    private static final String LISTENER = "/configs/config/{config}/network-config/network-listeners/network-listener/{listener}";
    private static final String PROTOCOL = "/configs/config/{config}/network-config/protocols/protocol/{protocol}";
    private static final String SYSTEM_PROPERTY_REGEX = "\\$\\{(.*)\\}";

    public GlassFishClientService(CommonGlassFishConfiguration configuration) {
        this.configuration = configuration;
        this.target = configuration.getTarget();
        StringBuilder adminUrlBuilder = new StringBuilder().append(NodeAddress.getHttpProtocolPrefix(this.configuration.isAdminHttps())).append(this.configuration.getAdminHost()).append(":").append(this.configuration.getAdminPort());
        this.DASUrl = adminUrlBuilder.toString();
        adminUrlBuilder.append("/management/domain");
        this.adminBaseUrl = adminUrlBuilder.toString();
        this.clientUtil = new GlassFishClientUtil(configuration, this.adminBaseUrl);
    }

    @Override
    public void startUp() throws GlassFishClientException {
        Map<Object, Object> standaloneServers = new HashMap();
        Map<Object, Object> clusters = new HashMap();
        try {
            standaloneServers = this.getServersList();
        }
        catch (Exception ch) {
            String message = "Could not connect to DAS on: " + this.getDASUrl() + " | " + ch.getCause().getMessage();
            throw new GlassFishClientException(message);
        }
        if ("server".equals(this.getTarget())) {
            this.serverInstance = new AdminServer();
        } else if (standaloneServers.containsKey(this.getTarget())) {
            this.serverInstance = new StandaloneServer();
        } else {
            clusters = this.getClustersList();
            if (clusters != null && clusters.containsKey(this.getTarget())) {
                this.serverInstance = new ClusterServer();
            } else {
                String message = "The target property: " + this.getTarget() + " is not a valid target";
                throw new GlassFishClientException(message);
            }
        }
        this.setGlassFishVersion();
        List<NodeAddress> nodeAddressList = this.serverInstance.getNodeAddressList();
        this.nodeAddress = "server".equals(this.configuration.getTarget()) ? nodeAddressList.get(0) : this.runningInstanceFilter(nodeAddressList);
    }

    private void setGlassFishVersion() {
        Object versionNumberObj;
        Map extraProperties;
        Map<String, Object> responseMap = this.getClientUtil().GETRequest(GLASSFISH_VERSION);
        if (responseMap != null && (extraProperties = (Map)responseMap.get("extraProperties")) != null && (versionNumberObj = extraProperties.get("version-number")) instanceof String) {
            String version = (String)versionNumberObj;
            StringTokenizer tokenizer = new StringTokenizer(version, ".");
            if (tokenizer.hasMoreElements()) {
                try {
                    this.majorVersion = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException ignore) {
                    log.info("Exception getting major version for: " + version);
                }
            }
            if (tokenizer.hasMoreElements()) {
                try {
                    this.minorVersion = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException ignore) {
                    log.info("Exception getting minor version for: " + version);
                }
            }
        }
    }

    private NodeAddress runningInstanceFilter(List<NodeAddress> nodeAddressList) {
        String message;
        List<Map> instanceList = this.getClientUtil().getInstancesList(INSTACE_LIST);
        String instanceStatus = null;
        for (Map instance : instanceList) {
            for (NodeAddress node : nodeAddressList) {
                if (!instance.get("name").equals(node.getServerName()) || !RUNNING_STATUS.equals(instanceStatus = (String)instance.get("status"))) continue;
                return node;
            }
        }
        if (nodeAddressList.size() == 1) {
            message = "The " + nodeAddressList.get(0).getServerName() + " server-instance status is: " + instanceStatus;
            throw new GlassFishClientException(message);
        }
        message = "Could not fund any instance with RUNNING status in cluster: " + this.getTarget();
        throw new GlassFishClientException(message);
    }

    @Override
    public HTTPContext doDeploy(String name, FormDataMultiPart form) {
        this.getClientUtil().POSTMultiPartRequest(APPLICATION, form);
        WebTarget listSubCompsGET = this.getClientUtil().prepareGET();
        Response response = listSubCompsGET.path("/applications/application/{name}/list-sub-components").resolveTemplate("name", (Object)name).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("User-Agent", (Object)USER_AGENT_VALUE).get();
        Map<String, Object> subComponentsResponce = this.getClientUtil().getResponseMap(response);
        Map subComponents = (Map)subComponentsResponce.get("properties");
        int port = this.nodeAddress.getHttpPort();
        HTTPContext httpContext = new HTTPContext(this.nodeAddress.getHost(), port);
        String contextRoot = this.getApplicationContextRoot(name);
        if (subComponents != null) {
            for (Map.Entry subComponent : subComponents.entrySet()) {
                String componentName = subComponent.getKey().toString();
                if (WEBMODULE.equals(subComponent.getValue())) {
                    List children = (List)subComponentsResponce.get("children");
                    contextRoot = this.resolveWebModuleContextRoot(componentName, children);
                    this.resolveWebModuleSubComponents(name, componentName, contextRoot, httpContext);
                    continue;
                }
                if (!SERVLET.equals(subComponent.getValue())) continue;
                httpContext.add(new Servlet(componentName, contextRoot));
            }
        }
        return httpContext;
    }

    @Override
    public Map doUndeploy(String name, FormDataMultiPart form) {
        String path = APPLICATION_RESOURCE.replace("{name}", name);
        return this.getClientUtil().POSTMultiPartRequest(path, form);
    }

    @Override
    public boolean isDASRunning() {
        block2: {
            try {
                this.getClientUtil().GETRequest("");
            }
            catch (GlassFishClientException clientEx) {
                if (!clientEx.getCause().getMessage().contains("ConnectException")) break block2;
                return false;
            }
        }
        return true;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    private Map<String, String> getServersList() {
        Map<String, String> standaloneServers = this.getClientUtil().getChildResources(STANALONE_SERVER_INSTACES);
        return standaloneServers;
    }

    private Map<String, String> getClustersList() {
        Map<String, String> clusters = this.getClientUtil().getChildResources(CLUSTERED_SERVER_INSTACES);
        return clusters;
    }

    private String getApplicationContextRoot(String name) {
        String path = APPLICATION_RESOURCE.replace("{name}", name);
        Map<String, String> applicationAttributes = this.getClientUtil().getAttributes(path);
        String contextRoot = applicationAttributes.get("contextRoot").toString();
        return contextRoot;
    }

    private String resolveWebModuleContextRoot(String componentName, List<Map<String, Map<String, String>>> modules) {
        String contextRoot = null;
        for (Map<String, Map<String, String>> module : modules) {
            Map<String, String> moduleProperties = module.get("properties");
            if (moduleProperties != null && !moduleProperties.isEmpty()) {
                String moduleInfo = moduleProperties.get("moduleInfo");
                if (!moduleInfo.startsWith(componentName)) continue;
                String[] moduleInfoElements = moduleInfo.split(":");
                contextRoot = moduleInfoElements[2];
                contextRoot = contextRoot.contains("/") ? contextRoot.substring(contextRoot.indexOf("/")) : contextRoot;
                continue;
            }
            throw new GlassFishClientException("Cuold not resolve the web-module contextRoot");
        }
        return contextRoot;
    }

    private void resolveWebModuleSubComponents(String name, String module, String context, HTTPContext httpContext) {
        WebTarget listAppSubCompGET = this.getClientUtil().prepareGET();
        Response response = listAppSubCompGET.path("/applications/application/{application}/list-sub-components").resolveTemplate("application", (Object)name).queryParam("appname", new Object[]{name}).queryParam("id", new Object[]{module}).queryParam("type", new Object[]{"servlets"}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("User-Agent", (Object)USER_AGENT_VALUE).get();
        Map<String, Object> subComponentsResponce = this.getClientUtil().getResponseMap(response);
        Map subComponents = (Map)subComponentsResponce.get("properties");
        for (Map.Entry subComponent : subComponents.entrySet()) {
            String componentName = (String)subComponent.getKey();
            httpContext.add(new Servlet(componentName, context));
        }
    }

    protected Map<String, String> getServerInstances(String target) {
        String path = MEMBER_SERVERS_RESOURCE.replace("{target}", target);
        Map<String, String> serverInstances = this.getClientUtil().getChildResources(path);
        return serverInstances;
    }

    protected Map<String, String> getServerAttributes(String server) {
        String path = SERVER_RESOURCE.replace("{server}", server);
        return this.getClientUtil().getAttributes(path);
    }

    protected Map<String, String> getClusterAttributes(String cluster) {
        String path = CLUSTER_RESOURCE.replace("{cluster}", cluster);
        return this.getClientUtil().getAttributes(path);
    }

    protected String getHostAddress(Map<String, String> serverAttributes) {
        String path = NODE_RESOURCE.replace("{node}", serverAttributes.get("nodeRef"));
        String nodeHost = this.getClientUtil().getAttributes(path).get("nodeHost");
        if (nodeHost.equals("localhost")) {
            nodeHost = this.configuration.getAdminHost();
        }
        return nodeHost;
    }

    private int getSystemProperty(Map<String, String> attributes, String propertyName) {
        String propertyPath = SYSTEM_PROPERTY.replace("{config}", attributes.get("configRef"));
        Map<String, String> listener = this.getClientUtil().getAttributes(propertyPath.replace("{system-property}", propertyName));
        return Integer.parseInt(listener.get("value"));
    }

    private int getServerSystemProperty(String server, String propertyName, int defaultValue) {
        String listenerpath = SERVER_PROPERTY.replace("{server}", server);
        Map<String, String> listener = this.getClientUtil().getAttributes(listenerpath.replace("{system-property}", propertyName));
        return listener.get("value") != null ? Integer.parseInt(listener.get("value")) : defaultValue;
    }

    protected int getServerInstanceHttpPort(String server, int default_port, boolean secure) {
        String listenerpath = HTTP_LISTENER_INS.replace("{server}", server);
        String httpListener = !secure ? "HTTP_LISTENER_PORT" : "HTTP_SSL_LISTENER_PORT";
        Map<String, String> listener = this.getClientUtil().getAttributes(listenerpath.replace("{http-listener}", httpListener));
        return listener.get("value") != null ? Integer.parseInt(listener.get("value")) : default_port;
    }

    private List<String> getVirtualServers(Map<String, String> attributes) {
        String config = attributes.get("configRef").replace("{target}", attributes.get("name"));
        WebTarget vsGET = this.getClientUtil().prepareGET();
        Response response = vsGET.path(VIRTUAL_SERVERS).resolveTemplate("config", (Object)config).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("User-Agent", (Object)USER_AGENT_VALUE).get();
        Map<String, Object> virtualServersResponse = this.getClientUtil().getResponseMap(response);
        List virtualServers = (List)virtualServersResponse.get("children");
        ArrayList<String> virtualServerNames = new ArrayList<String>();
        for (Map virtualServer : virtualServers) {
            String virtualServerName = (String)virtualServer.get("message");
            if (virtualServerName.equals("__asadmin")) continue;
            virtualServerNames.add(virtualServerName);
        }
        return virtualServerNames;
    }

    private List<String> getNetworkListeners(Map<String, String> attributes, List<String> virtualServers) {
        ArrayList<String> networkListeners = new ArrayList<String>();
        Properties properties = new Properties();
        for (String virtualServer : virtualServers) {
            String[] listeners;
            String virtualServerPath = VIRTUAL_SERVER.replace("{config}", attributes.get("configRef")).replace("{virtualServer}", virtualServer);
            Map<String, String> virtualServerAttributes = this.getClientUtil().getAttributes(virtualServerPath);
            String listenerList = virtualServerAttributes.get("networkListeners");
            for (String listener : listeners = listenerList.split(",")) {
                networkListeners.add(listener.trim());
            }
        }
        return networkListeners;
    }

    private String getActiveHttpPort(Map<String, String> attributes, List<String> networkListeners, boolean secure) {
        for (String networkListener : networkListeners) {
            String listenerPath = LISTENER.replace("{config}", attributes.get("configRef")).replace("{listener}", networkListener);
            Map<String, String> listenerAttributes = this.getClientUtil().getAttributes(listenerPath);
            boolean enabled = Boolean.parseBoolean(listenerAttributes.get("enabled"));
            if (!enabled) continue;
            String port = listenerAttributes.get("port");
            String protocolName = listenerAttributes.get("protocol");
            boolean secureProtocol = this.isSecureProtocol(attributes, protocolName);
            if (secure && secureProtocol) {
                return port;
            }
            if (secure || secureProtocol) continue;
            return port;
        }
        return null;
    }

    private boolean isSecureProtocol(Map<String, String> attributes, String protocolName) {
        String protocolPath = PROTOCOL.replace("{config}", attributes.get("configRef")).replace("{protocol}", protocolName);
        Map<String, String> protocolAttributes = this.getClientUtil().getAttributes(protocolPath);
        boolean isSecure = Boolean.parseBoolean(protocolAttributes.get("securityEnabled"));
        return isSecure;
    }

    private int getPortValue(Map<String, String> attributes, String serverName, String portNum) {
        int portValue;
        block2: {
            portValue = -1;
            try {
                portValue = Integer.parseInt(portNum);
            }
            catch (NumberFormatException formatEx) {
                Pattern propertyRegex = Pattern.compile(SYSTEM_PROPERTY_REGEX);
                Matcher matcher = propertyRegex.matcher(portNum);
                if (!matcher.find()) break block2;
                String propertyName = matcher.group(1);
                portValue = this.getSystemProperty(attributes, propertyName);
                portValue = this.getServerSystemProperty(serverName, propertyName, portValue);
            }
        }
        return portValue;
    }

    private CommonGlassFishConfiguration getConfiguration() {
        return this.configuration;
    }

    private String getTarget() {
        return this.target;
    }

    private void setTarget(String target) {
        this.target = target;
    }

    private GlassFishClientUtil getClientUtil() {
        return this.clientUtil;
    }

    private String getDASUrl() {
        return this.DASUrl;
    }

    class ClusterServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            Map<String, String> clusterAttributes = GlassFishClientService.this.getClusterAttributes(GlassFishClientService.this.getTarget());
            Map<String, String> serverInstances = GlassFishClientService.this.getServerInstances(GlassFishClientService.this.getTarget());
            List virtualServers = GlassFishClientService.this.getVirtualServers(clusterAttributes);
            List networkListeners = GlassFishClientService.this.getNetworkListeners(clusterAttributes, virtualServers);
            String httpPortNum = GlassFishClientService.this.getActiveHttpPort(clusterAttributes, networkListeners, false);
            String httpsPortNum = GlassFishClientService.this.getActiveHttpPort(clusterAttributes, networkListeners, true);
            for (Map.Entry<String, String> serverInstance : serverInstances.entrySet()) {
                String serverName = serverInstance.getKey().toString();
                Map<String, String> serverAttributes = GlassFishClientService.this.getServerAttributes(serverName);
                nodeHost = GlassFishClientService.this.getHostAddress(serverAttributes);
                int httpPort = GlassFishClientService.this.getPortValue(clusterAttributes, serverName, httpPortNum);
                int httpsPort = -1;
                if (httpsPortNum != null && !httpsPortNum.equals("")) {
                    httpsPort = GlassFishClientService.this.getPortValue(clusterAttributes, serverName, httpsPortNum);
                }
                this.addNode(new NodeAddress(serverName, nodeHost, httpPort, httpsPort));
            }
            return this.getNodes();
        }
    }

    class StandaloneServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            Map<String, String> serverAttributes = GlassFishClientService.this.getServerAttributes(GlassFishClientService.this.getTarget());
            nodeHost = GlassFishClientService.this.getHostAddress(serverAttributes);
            List virtualServers = GlassFishClientService.this.getVirtualServers(serverAttributes);
            List networkListeners = GlassFishClientService.this.getNetworkListeners(serverAttributes, virtualServers);
            String httpPortNum = GlassFishClientService.this.getActiveHttpPort(serverAttributes, networkListeners, false);
            String httpsPortNum = GlassFishClientService.this.getActiveHttpPort(serverAttributes, networkListeners, true);
            int httpPort = GlassFishClientService.this.getPortValue(serverAttributes, GlassFishClientService.this.getTarget(), httpPortNum);
            int httpsPort = -1;
            if (httpsPortNum != null && !httpsPortNum.equals("")) {
                httpsPort = GlassFishClientService.this.getPortValue(serverAttributes, GlassFishClientService.this.getTarget(), httpsPortNum);
            }
            this.addNode(new NodeAddress(GlassFishClientService.this.getTarget(), nodeHost, httpPort, httpsPort));
            return this.getNodes();
        }
    }

    class AdminServer
    extends ServerStartegy {
        @Override
        public List<NodeAddress> getNodeAddressList() {
            String nodeHost = "localhost";
            this.setNodes(new ArrayList<NodeAddress>());
            int count = 10;
            Map<String, String> serverAttributes = GlassFishClientService.this.getServerAttributes("server");
            while (serverAttributes.size() == 0 && count-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                serverAttributes = GlassFishClientService.this.getServerAttributes("server");
            }
            nodeHost = GlassFishClientService.this.getConfiguration().getAdminHost();
            List virtualServers = GlassFishClientService.this.getVirtualServers(serverAttributes);
            List networkListeners = GlassFishClientService.this.getNetworkListeners(serverAttributes, virtualServers);
            String httpPortNum = GlassFishClientService.this.getActiveHttpPort(serverAttributes, networkListeners, false);
            String httpsPortNum = GlassFishClientService.this.getActiveHttpPort(serverAttributes, networkListeners, true);
            int httpPort = GlassFishClientService.this.getPortValue(serverAttributes, GlassFishClientService.this.getTarget(), httpPortNum);
            int httpsPort = -1;
            if (httpsPortNum != null && !httpsPortNum.equals("")) {
                httpsPort = GlassFishClientService.this.getPortValue(serverAttributes, GlassFishClientService.this.getTarget(), httpsPortNum);
            }
            this.addNode(new NodeAddress("server", nodeHost, httpPort, httpsPort));
            return this.getNodes();
        }
    }

    abstract class ServerStartegy {
        private List<NodeAddress> nodes = new ArrayList<NodeAddress>();
        protected GlassFishClientService glassFishClient;

        protected ServerStartegy() {
        }

        protected List<NodeAddress> getNodes() {
            return this.nodes;
        }

        protected void setNodes(List<NodeAddress> nodes) {
            this.nodes = nodes;
        }

        protected void addNode(NodeAddress node) {
            this.nodes.add(node);
        }

        protected GlassFishClientService getGlassFishClient() {
            return this.glassFishClient;
        }

        protected abstract List<NodeAddress> getNodeAddressList();
    }
}

