/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.clientutils;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.clientutils.GlassFishClientException;

public class GlassFishClientUtil {
    public static final String SUCCESS = "SUCCESS";
    public static final String WARNING = "WARNING";
    private CommonGlassFishConfiguration configuration;
    private String adminBaseUrl;
    private static final Logger log = Logger.getLogger(GlassFishClientUtil.class.getName());

    public GlassFishClientUtil(CommonGlassFishConfiguration configuration, String adminBaseUrl) {
        this.configuration = configuration;
        this.adminBaseUrl = adminBaseUrl;
    }

    public CommonGlassFishConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getAttributes(String additionalResourceUrl) {
        Map<String, Object> responseMap = this.GETRequest(additionalResourceUrl);
        Map<String, String> attributes = new HashMap<String, String>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            attributes = (Map)resultExtraProperties.get("entity");
        }
        return attributes;
    }

    public Map<String, String> getChildResources(String additionalResourceUrl) throws GlassFishClientException {
        Map<String, Object> responseMap = this.GETRequest(additionalResourceUrl);
        Map<String, String> childResources = new HashMap<String, String>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            childResources = (Map)resultExtraProperties.get("childResources");
        }
        return childResources;
    }

    public WebTarget prepareGET() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        ClientConfig jerseyConfig = new ClientConfig();
        if (this.configuration.isAuthorisation()) {
            jerseyConfig.register((Object)HttpAuthenticationFeature.basic((String)this.configuration.getAdminUser(), (String)this.configuration.getAdminPassword()));
        }
        if (this.configuration.isDebugRequests()) {
            jerseyConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(10000)));
        }
        builder.withConfig((Configuration)jerseyConfig);
        builder.register((Object)new CsrfProtectionFilter());
        Client client = builder.build();
        return client.target(this.adminBaseUrl);
    }

    public Map<String, Object> GETRequest(String adminSubPath) {
        try {
            Invocation.Builder getBuilder = this.prepareClient(adminSubPath, false);
            Response response = getBuilder.buildGet().invoke();
            Map<String, Object> responseMap = this.getResponseMap(response);
            return responseMap;
        }
        catch (Exception e) {
            throw new GlassFishClientException(e);
        }
    }

    public List<Map> getInstancesList(String additionalResourceUrl) throws GlassFishClientException {
        Map<String, Object> responseMap = this.GETRequest(additionalResourceUrl);
        List instancesList = new ArrayList<Map>();
        Map resultExtraProperties = (Map)responseMap.get("extraProperties");
        if (resultExtraProperties != null) {
            instancesList = (List)resultExtraProperties.get("instanceList");
        }
        return instancesList;
    }

    public Map<String, Object> POSTMultiPartRequest(String additionalResourceUrl, FormDataMultiPart form) {
        try {
            Response response = this.prepareClient(additionalResourceUrl, true).accept(new MediaType[]{MediaType.MULTIPART_FORM_DATA_TYPE}).buildPost(Entity.entity((Object)form, (String)"multipart/form-data")).invoke();
            Map<String, Object> responseMap = this.getResponseMap(response);
            return responseMap;
        }
        catch (Exception e) {
            throw new GlassFishClientException(e);
        }
    }

    private Invocation.Builder prepareClient(String additionalResourceUrl, boolean multiPart) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        ClientConfig jerseyConfig = new ClientConfig();
        if (this.configuration.isAuthorisation()) {
            jerseyConfig.register((Object)HttpAuthenticationFeature.basic((String)this.configuration.getAdminUser(), (String)this.configuration.getAdminPassword()));
        }
        if (multiPart) {
            jerseyConfig.register(MultiPartFeature.class);
        }
        if (this.configuration.isDebugRequests()) {
            jerseyConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(10000)));
        }
        builder.withConfig((Configuration)jerseyConfig);
        builder.register((Object)new CsrfProtectionFilter());
        Client client = builder.build();
        return client.target(this.adminBaseUrl).path(additionalResourceUrl).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("User-Agent", (Object)"arquillian-glassfish-managed-6");
    }

    Map<String, Object> getResponseMap(Response response) throws GlassFishClientException {
        Response.StatusType status;
        Map<Object, Object> responseMap = new HashMap();
        String message = "";
        String xmlDoc = (String)response.readEntity(String.class);
        if (xmlDoc != null && !xmlDoc.isEmpty()) {
            responseMap = this.xmlToMap(xmlDoc);
            message = "exit_code: " + responseMap.get("exit_code") + ", message: " + responseMap.get("message");
        }
        if ((status = response.getStatusInfo()).getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (responseMap.get("exit_code") == null) {
                throw new GlassFishClientException(message);
            }
            if (WARNING.equals(responseMap.get("exit_code"))) {
                log.warning("Deployment resulted in a warning: " + message);
            } else if (!SUCCESS.equals(responseMap.get("exit_code"))) {
                throw new GlassFishClientException(message);
            }
        } else if (status.getReasonPhrase().contains("Not Found")) {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.warning(message);
        } else {
            message = message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.severe(message);
            throw new GlassFishClientException(message);
        }
        return responseMap;
    }

    public Map<String, Object> xmlToMap(String document) {
        if (document == null) {
            return new HashMap<String, Object>();
        }
        InputStream input = null;
        Map<String, Object> map = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", false);
            input = new ByteArrayInputStream(document.trim().getBytes("UTF-8"));
            XMLStreamReader stream = factory.createXMLStreamReader(input);
            while (stream.hasNext()) {
                int currentEvent = stream.next();
                if (currentEvent != 1 || !"map".equals(stream.getLocalName())) continue;
                map = this.resolveXmlMap(stream);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        return map;
    }

    private Map<String, Object> resolveXmlMap(XMLStreamReader stream) throws XMLStreamException {
        boolean endMapFlag = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String elementName = null;
        while (!endMapFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                Object value;
                if ("entry".equals(stream.getLocalName())) {
                    key = stream.getAttributeValue(null, "key");
                    value = stream.getAttributeValue(null, "value");
                    if (value == null) continue;
                    entry.put(key, value);
                    key = null;
                    continue;
                }
                if ("map".equals(stream.getLocalName())) {
                    value = this.resolveXmlMap(stream);
                    entry.put(key, value);
                    continue;
                }
                if ("list".equals(stream.getLocalName())) {
                    value = this.resolveXmlList(stream);
                    entry.put(key, value);
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("map".equals(stream.getLocalName())) {
                    endMapFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    entry.put(key, Double.parseDouble(document));
                } else {
                    entry.put(key, Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                entry.put(key, document);
            }
            elementName = null;
        }
        return entry;
    }

    private List resolveXmlList(XMLStreamReader stream) throws XMLStreamException {
        boolean endListFlag = false;
        ArrayList<Object> list = new ArrayList<Object>();
        String elementName = null;
        while (!endListFlag) {
            int currentEvent = stream.next();
            if (currentEvent == 1) {
                if ("map".equals(stream.getLocalName())) {
                    list.add(this.resolveXmlMap(stream));
                    continue;
                }
                elementName = stream.getLocalName();
                continue;
            }
            if (currentEvent == 2) {
                if ("list".equals(stream.getLocalName())) {
                    endListFlag = true;
                }
                elementName = null;
                continue;
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    list.add(Double.parseDouble(document));
                } else {
                    list.add(Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                list.add(document);
            }
            elementName = null;
        }
        return list;
    }
}

