/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_6_1;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.arquillian.container.jetty.EnvUtil;
import org.jboss.arquillian.container.jetty.embedded_6_1.JettyEmbeddedConfiguration;
import org.jboss.arquillian.container.jetty.embedded_6_1.JettyUtilLog;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.jetty_6.api.ShrinkWrapWebAppContext;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyEmbeddedContainer
implements DeployableContainer<JettyEmbeddedConfiguration> {
    public static final String HTTP_PROTOCOL = "http";
    public static final String[] WEBAPP_CONFIGURATION_CLASSES_PLUS;
    private static final java.util.logging.Logger log;
    private Server server;
    private ContextHandlerCollection contexts;
    private String listeningHost;
    private int listeningPort;
    private String[] webappConfigurationClasses = null;
    private JettyEmbeddedConfiguration containerConfig;
    @Inject
    @DeploymentScoped
    private InstanceProducer<WebAppContext> webAppContextProducer;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ServletContext> servletContextInstanceProducer;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 2.5");
    }

    public Class<JettyEmbeddedConfiguration> getConfigurationClass() {
        return JettyEmbeddedConfiguration.class;
    }

    public void setup(JettyEmbeddedConfiguration containerConfig) {
        this.containerConfig = containerConfig;
    }

    public void start() throws LifecycleException {
        EnvUtil.assertMinimumJettyVersion((String)Server.getVersion(), (String)"6.1");
        try {
            this.webappConfigurationClasses = this.getWebAppConfigurationClasses();
            this.server = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            if (this.containerConfig.isHeaderBufferSizeSet()) {
                connector.setHeaderBufferSize(this.containerConfig.getHeaderBufferSize());
            }
            connector.setHost(this.containerConfig.getBindAddress());
            connector.setPort(this.containerConfig.getBindHttpPort());
            this.server.setConnectors(new Connector[]{connector});
            this.contexts = new ContextHandlerCollection();
            Handler[] handlers = new Handler[]{this.contexts, new DefaultHandler()};
            this.server.setHandlers(handlers);
            if (this.containerConfig.isRealmPropertiesFileSet()) {
                String realmName = this.getRealmName();
                HashUserRealm hashUserRealm = new HashUserRealm(realmName, this.containerConfig.getRealmProperties().getAbsolutePath());
                this.server.addUserRealm((UserRealm)hashUserRealm);
            }
            this.server.start();
            this.listeningHost = this.containerConfig.getBindAddress();
            if (connector.getHost() != null) {
                this.listeningHost = connector.getHost();
            }
            this.listeningPort = connector.getLocalPort();
            if (this.listeningPort <= 0) {
                throw new LifecycleException("Connector not listening on any port");
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    private String getRealmName() {
        File realmProperties = this.containerConfig.getRealmProperties();
        String fileName = realmProperties.getName();
        int index = -1;
        index = fileName.indexOf(46);
        if (index > -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    private String[] getWebAppConfigurationClasses() {
        String configuredConfigurationClasses = this.containerConfig.getConfigurationClasses();
        if (configuredConfigurationClasses != null && configuredConfigurationClasses.trim().length() > 0) {
            return configuredConfigurationClasses.split(",");
        }
        if (this.containerConfig.isJettyPlus()) {
            return WEBAPP_CONFIGURATION_CLASSES_PLUS;
        }
        return null;
    }

    public void stop() throws LifecycleException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            WebAppContext wctx = (WebAppContext)archive.as(ShrinkWrapWebAppContext.class);
            if (this.webappConfigurationClasses != null) {
                wctx.setConfigurationClasses(this.webappConfigurationClasses);
            }
            if (this.containerConfig.areMimeTypesSet()) {
                MimeTypes mimeTypes = this.getMimeTypes();
                wctx.setMimeTypes(mimeTypes);
            }
            wctx.setExtractWAR(true);
            wctx.setLogUrlOnStart(true);
            wctx.setParentLoaderPriority(true);
            this.contexts.addHandler((Handler)wctx);
            wctx.start();
            this.webAppContextProducer.set((Object)wctx);
            this.servletContextInstanceProducer.set((Object)wctx.getServletContext());
            HTTPContext httpContext = new HTTPContext(this.listeningHost, this.listeningPort);
            for (ServletHolder servlet : wctx.getServletHandler().getServlets()) {
                httpContext.add(new Servlet(servlet.getName(), wctx.getContextPath()));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
    }

    private MimeTypes getMimeTypes() {
        Map configuredMimeTypes = this.containerConfig.getMimeTypes();
        Set entries = configuredMimeTypes.entrySet();
        MimeTypes mimeTypes = new MimeTypes();
        for (Map.Entry entry : entries) {
            mimeTypes.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
        }
        return mimeTypes;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        WebAppContext wctx = (WebAppContext)this.webAppContextProducer.get();
        if (wctx != null) {
            try {
                wctx.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.severe("Could not stop context " + wctx.getContextPath() + ": " + e.getMessage());
            }
            this.contexts.removeHandler((Handler)wctx);
        }
    }

    static {
        Log.setLog((Logger)new JettyUtilLog());
        WEBAPP_CONFIGURATION_CLASSES_PLUS = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.plus.webapp.EnvConfiguration", "org.mortbay.jetty.plus.webapp.Configuration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration"};
        log = java.util.logging.Logger.getLogger(JettyEmbeddedContainer.class.getName());
    }
}

