/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_6_1;

import java.util.logging.Level;
import org.mortbay.log.Logger;

public class JettyUtilLog
implements Logger {
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JettyUtilLog() {
        this("org.mortbay.log");
    }

    public JettyUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        this.configuredLevel = this._logger.getLevel();
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.format(msg, new Object[]{arg0, arg1}));
        }
    }

    public void debug(String msg, Throwable thrown) {
        this._logger.log(Level.FINE, msg, thrown);
    }

    private String format(String msg, Object arg0, Object arg1) {
        return this.format(msg, new Object[]{arg0, arg1});
    }

    private String format(String msg, Object[] args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }

    public Logger getLogger(String name) {
        return this.newLogger(name);
    }

    public String getName() {
        return this._logger.getName();
    }

    public void info(String msg, Object arg0, Object arg1) {
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.log(Level.INFO, this.format(msg, arg0, arg1));
        }
    }

    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    protected Logger newLogger(String fullname) {
        return new JettyUtilLog(fullname);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    public void warn(String msg, Object arg0, Object arg1) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, this.format(msg, arg0, arg1));
        }
    }

    public void warn(String msg, Throwable thrown) {
        this._logger.log(Level.WARNING, msg, thrown);
    }
}

