/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_7;

import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.arquillian.container.jetty.embedded_7.JettyEmbeddedConfiguration;
import org.jboss.arquillian.protocol.servlet_3.ServletMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.jetty_7.api.ShrinkWrapWebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyEmbeddedContainer
implements DeployableContainer {
    public static final String HTTP_PROTOCOL = "http";
    public static final String[] JETTY_PLUS_CONFIGURATION_CLASSES = new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.Configuration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"};
    private static final Logger log = Logger.getLogger(JettyEmbeddedContainer.class.getName());
    private Server server;
    private JettyEmbeddedConfiguration containerConfig;

    public void setup(Context context, Configuration arquillianConfig) {
        this.containerConfig = (JettyEmbeddedConfiguration)arquillianConfig.getContainerConfig(JettyEmbeddedConfiguration.class);
    }

    public void start(Context context) throws LifecycleException {
        try {
            this.server = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setHost(this.containerConfig.getBindAddress());
            connector.setPort(this.containerConfig.getBindHttpPort());
            this.server.setConnectors(new Connector[]{connector});
            this.server.setHandler((Handler)new HandlerCollection(true));
            log.info("Starting Jetty Embedded Server " + Server.getVersion() + " [id:" + this.server.hashCode() + "]");
            this.server.start();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            log.info("Stopping Jetty Embedded Server [id:" + this.server.hashCode() + "]");
            this.server.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            WebAppContext wctx = (WebAppContext)archive.as(ShrinkWrapWebAppContext.class);
            if (this.containerConfig.isJettyPlus()) {
                wctx.setConfigurationClasses(JETTY_PLUS_CONFIGURATION_CLASSES);
            }
            wctx.setExtractWAR(true);
            wctx.setLogUrlOnStart(true);
            wctx.setParentLoaderPriority(true);
            ((HandlerCollection)this.server.getHandler()).addHandler((Handler)wctx);
            wctx.start();
            context.add(WebAppContext.class, (Object)wctx);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
        try {
            return new ServletMethodExecutor(new URL(HTTP_PROTOCOL, this.containerConfig.getBindAddress(), this.containerConfig.getBindHttpPort(), "/"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create ContainerMethodExecutor", e);
        }
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        WebAppContext wctx = (WebAppContext)context.get(WebAppContext.class);
        if (wctx != null) {
            try {
                wctx.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.severe("Could not stop context " + wctx.getContextPath() + ": " + e.getMessage());
            }
            ((HandlerCollection)this.server.getHandler()).removeHandler((Handler)wctx);
        }
    }
}

