/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openejb.embedded_3_1;

import java.util.logging.Logger;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.jboss.arquillian.container.openejb.embedded_3_1.OpenEJBConfiguration;
import org.jboss.arquillian.protocol.local.LocalMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.openejb.config.ShrinkWrapConfigurationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(OpenEJBContainer.class.getName());
    private Assembler assembler;
    private ShrinkWrapConfigurationFactory config;
    private AppInfo deployment;
    private OpenEJBConfiguration configuration;

    public void setup(Context context, Configuration configuration) {
        this.configuration = (OpenEJBConfiguration)configuration.getContainerConfig(OpenEJBConfiguration.class);
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        AppInfo appInfo;
        try {
            appInfo = this.config.configureApplication(archive);
            context.add(AppInfo.class, (Object)appInfo);
            this.deployment = appInfo;
        }
        catch (OpenEJBException e) {
            throw new DeploymentException("Could not configure application in OpenEJB", (Throwable)e);
        }
        try {
            this.assembler.createApplication(appInfo);
        }
        catch (Exception ne) {
            throw new DeploymentException("Could not create the application", (Throwable)ne);
        }
        return new LocalMethodExecutor();
    }

    public void start(Context context) throws LifecycleException {
        ShrinkWrapConfigurationFactory config = new ShrinkWrapConfigurationFactory();
        Assembler assembler = new Assembler();
        try {
            assembler.createTransactionManager((TransactionServiceInfo)config.configureService(TransactionServiceInfo.class));
            assembler.createSecurityService((SecurityServiceInfo)config.configureService(SecurityServiceInfo.class));
        }
        catch (OpenEJBException e) {
            throw new LifecycleException("Could not configure the OpenEJB Container", (Throwable)e);
        }
        this.assembler = assembler;
        this.config = new ShrinkWrapConfigurationFactory();
    }

    public void stop(Context context) throws LifecycleException {
        this.assembler.destroy();
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            this.assembler.destroyApplication(this.deployment.jarPath);
        }
        catch (UndeployException e) {
            throw new DeploymentException("Error in undeployment of " + archive.getName(), (Throwable)e);
        }
        catch (NoSuchApplicationException e) {
            throw new DeploymentException("Application was not deployed; cannot undeploy: " + archive.getName(), (Throwable)e);
        }
    }
}

