/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.embedded_4_2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiEmbeddedContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(OSGiEmbeddedContainer.class);
    private Framework framework;

    public void setup(Context context, Configuration configuration) {
        OSGiBootstrapProvider provider = OSGiBootstrap.getBootstrapProvider();
        this.framework = provider.getFramework();
        context.add(Framework.class, (Object)this.framework);
    }

    public void start(Context context) throws LifecycleException {
        try {
            this.framework.start();
            context.add(BundleContext.class, (Object)this.framework.getBundleContext());
            Bundle[] bundles = this.framework.getBundleContext().getBundles();
            if (this.getInstalledBundle(bundles, "osgi.cmpn") == null) {
                this.installBundle("org.osgi.compendium", false);
            }
            if (this.getInstalledBundle(bundles, "arquillian-protocol-jmx-osgi-bundle") == null) {
                this.installBundle("arquillian-protocol-jmx-osgi-bundle", true);
            }
        }
        catch (BundleException ex) {
            throw new LifecycleException("Cannot start embedded OSGi Framework", (Throwable)ex);
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            this.framework.stop();
            this.framework.waitForStop(3000L);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot stop embedded OSGi Framework", (Throwable)ex);
        }
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.exportZip((OutputStream)baos);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            BundleContext sysContext = this.framework.getBundleContext();
            Bundle bundle = sysContext.installBundle(archive.getName(), (InputStream)inputStream);
            context.add(Bundle.class, (Object)bundle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive, (Throwable)ex);
        }
        return new JMXMethodExecutor();
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            Bundle bundle = (Bundle)context.get(Bundle.class);
            if (bundle != null) {
                bundle.uninstall();
            }
        }
        catch (BundleException ex) {
            log.error((Object)("Cannot undeploy: " + archive), (Throwable)ex);
        }
    }

    private Bundle getInstalledBundle(Bundle[] bundles, String symbolicName) {
        for (Bundle aux : bundles) {
            if (!symbolicName.equals(aux.getSymbolicName())) continue;
            return aux;
        }
        return null;
    }

    private Bundle installBundle(String artifactId, boolean startBundle) {
        String[] paths;
        String classPath = System.getProperty("java.class.path");
        if (!classPath.contains(artifactId)) {
            log.debug((Object)("Class path does not contain '" + artifactId + "'"));
            return null;
        }
        for (String path : paths = classPath.split("" + File.pathSeparatorChar)) {
            if (!path.contains(artifactId)) continue;
            BundleContext sysContext = this.framework.getBundleContext();
            try {
                Bundle bundle = sysContext.installBundle(new File(path).toURI().toString());
                if (startBundle) {
                    bundle.start();
                }
                return bundle;
            }
            catch (BundleException ex) {
                log.error((Object)("Cannot install bundle: " + path));
            }
        }
        return null;
    }
}

