/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.remote;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.osgi.internal.AbstractDeployableContainer;
import org.jboss.arquillian.osgi.internal.JMXServiceURLFactory;
import org.jboss.arquillian.protocol.jmx.JMXConnectorServerExt;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXServerFactory;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.ManagementSupport;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeployableContainer
extends AbstractDeployableContainer {
    private static final Logger log = Logger.getLogger(RemoteDeployableContainer.class);
    private static JMXConnectorServerExt jmxConnectorServer;
    private JMXConnector jmxConnector;
    private ManagementSupport jmxSupport;

    public void start(Context context) throws LifecycleException {
        if (jmxConnectorServer == null) {
            jmxConnectorServer = this.createJMXConnectorServer();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                RemoteDeployableContainer.this.shutdownJMXConnectors();
            }
        });
        MBeanServerConnection connection = this.getMBeanServerConnection();
        this.jmxSupport = new ManagementSupport(connection);
        super.start(context);
        this.installSupportBundles();
    }

    public void stop(Context context) throws LifecycleException {
        super.stop(context);
    }

    private void shutdownJMXConnectors() {
        if (jmxConnectorServer != null) {
            jmxConnectorServer.stop();
            jmxConnectorServer = null;
        }
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Cannot close JMXConnector", (Throwable)ex);
            }
        }
    }

    public ContainerMethodExecutor getMethodExecutor(Properties props) {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
        props.put(JMXMethodExecutor.ExecutionType.class, JMXMethodExecutor.ExecutionType.REMOTE);
        return new JMXMethodExecutor(mbeanServer, props);
    }

    public AbstractDeployableContainer.BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = OSGiTestHelper.toVirtualFile(archive);
        return this.installBundle(virtualFile);
    }

    public AbstractDeployableContainer.BundleHandle installBundle(URL bundleURL) throws BundleException, IOException {
        VirtualFile virtualFile = AbstractVFS.getRoot((URL)bundleURL);
        return this.installBundle(virtualFile);
    }

    private AbstractDeployableContainer.BundleHandle installBundle(VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        String streamURL = info.getRoot().getStreamURL().toExternalForm();
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        long bundleId = frameworkMBean.installBundleFromURL(info.getLocation(), streamURL);
        return new AbstractDeployableContainer.BundleHandle(bundleId, info.getSymbolicName());
    }

    public void uninstallBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException, IOException {
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        frameworkMBean.uninstallBundle(handle.getBundleId());
    }

    public int getBundleState(AbstractDeployableContainer.BundleHandle handle) {
        String state;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                try {
                                    BundleStateMBean bundleState = this.jmxSupport.getBundleStateMBean();
                                    state = bundleState.getState(handle.getBundleId());
                                    if (!"INSTALLED".equals(state)) break block9;
                                    return 2;
                                }
                                catch (Exception ex) {
                                    Throwable cause;
                                    Throwable throwable = cause = ex.getCause() != null ? ex.getCause() : ex;
                                    if (!(cause instanceof InstanceNotFoundException)) {
                                        log.warn((Object)("Cannot get state for bundle: " + (Object)((Object)this)), cause);
                                    }
                                    return 1;
                                }
                            }
                            if (!"RESOLVED".equals(state)) break block10;
                            return 4;
                        }
                        if (!"STARTING".equals(state)) break block11;
                        return 8;
                    }
                    if (!"ACTIVE".equals(state)) break block12;
                    return 32;
                }
                if (!"STOPPING".equals(state)) break block13;
                return 16;
            }
            if (!"UNINSTALLED".equals(state)) break block14;
            return 1;
        }
        throw new IllegalStateException("Unsupported state: " + state);
    }

    public void startBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException {
        try {
            FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
            frameworkMBean.startBundle(handle.getBundleId());
        }
        catch (IOException ex) {
            throw new BundleException("Cannot start bundle: " + handle, (Throwable)ex);
        }
    }

    public void stopBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException {
        try {
            FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
            frameworkMBean.stopBundle(handle.getBundleId());
        }
        catch (IOException ex) {
            throw new BundleException("Cannot start bundle: " + handle, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBundleInstalled(String symbolicName) {
        try {
            CompositeData bundleType;
            String bsn;
            BundleStateMBean bundleStateMBean = this.jmxSupport.getBundleStateMBean();
            TabularData listBundles = bundleStateMBean.listBundles();
            Iterator<?> iterator = listBundles.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(bsn = (String)(bundleType = (CompositeData)iterator.next()).get("SymbolicName")).equals(symbolicName));
            return true;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    private MBeanServerConnection getMBeanServerConnection() {
        String jmxHost = System.getProperty("org.jboss.osgi.jmx.host", System.getProperty("jboss.bind.address", "localhost"));
        int jmxPort = Integer.parseInt(System.getProperty("org.jboss.osgi.jmx.rmi.port", "1198"));
        int rmiPort = Integer.parseInt(System.getProperty("org.jboss.osgi.jmx.rmi.registry.port", "1090"));
        JMXServiceURL serviceURL = JMXServiceURLFactory.getServiceURL((String)jmxHost, (Integer)jmxPort, (Integer)rmiPort, (String)"osgi-jmx-connector");
        try {
            if (this.jmxConnector == null) {
                log.debug((Object)("Connecting JMXConnector to: " + serviceURL));
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + serviceURL, ex);
        }
    }

    private JMXConnectorServerExt createJMXConnectorServer() {
        String jmxHost = System.getProperty("org.jboss.osgi.jmx.host", System.getProperty("jboss.bind.address", "localhost"));
        int jmxPort = Integer.parseInt(System.getProperty("org.jboss.osgi.jmx.rmi.port", "1198"));
        int rmiPort = Integer.parseInt(System.getProperty("org.jboss.osgi.jmx.rmi.registry.port", "1090"));
        JMXServiceURL serviceURL = JMXServiceURLFactory.getServiceURL((String)jmxHost, (Integer)(jmxPort + 1), (Integer)rmiPort, (String)"arquillian-osgi-callback");
        try {
            log.debug((Object)("Starting JMXConnectorServer on: " + serviceURL));
            JMXConnectorServerExt connectorServer = new JMXConnectorServerExt(serviceURL, rmiPort);
            connectorServer.start(JMXServerFactory.findOrCreateMBeanServer());
            return connectorServer;
        }
        catch (IOException ex) {
            log.error((Object)("Cannot start JMXConnectorServer on: " + serviceURL), (Throwable)ex);
            return null;
        }
    }
}

