/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.remote;

import java.io.IOException;
import java.net.URL;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.osgi.internal.AbstractDeployableContainer;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.Logger;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.ManagementSupport;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;

public class RemoteDeployableContainer
extends AbstractDeployableContainer {
    private static final Logger log = Logger.getLogger(RemoteDeployableContainer.class);
    private JMXConnector jmxConnector;
    private ManagementSupport jmxSupport;

    public void start(Context context) throws LifecycleException {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        this.jmxSupport = new ManagementSupport(connection);
        super.start(context);
        this.installSupportBundles();
    }

    public void stop(Context context) throws LifecycleException {
        super.stop(context);
    }

    public ContainerMethodExecutor getContainerMethodExecutor() {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
        return new JMXMethodExecutor(mbeanServer, JMXMethodExecutor.ExecutionType.REMOTE);
    }

    public AbstractDeployableContainer.BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = OSGiTestHelper.toVirtualFile(archive);
        return this.installBundle(virtualFile);
    }

    public AbstractDeployableContainer.BundleHandle installBundle(URL bundleURL) throws BundleException, IOException {
        VirtualFile virtualFile = AbstractVFS.toVirtualFile((URL)bundleURL);
        return this.installBundle(virtualFile);
    }

    private AbstractDeployableContainer.BundleHandle installBundle(VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        String streamURL = info.getRoot().getStreamURL().toExternalForm();
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        long bundleId = frameworkMBean.installBundleFromURL(info.getLocation(), streamURL);
        return new AbstractDeployableContainer.BundleHandle(bundleId, info.getSymbolicName());
    }

    public void resolveBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException, IOException {
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        frameworkMBean.resolveBundle(handle.getBundleId());
    }

    public void uninstallBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException, IOException {
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        frameworkMBean.uninstallBundle(handle.getBundleId());
    }

    public int getBundleState(AbstractDeployableContainer.BundleHandle handle) {
        try {
            BundleStateMBean bundleState = this.jmxSupport.getBundleStateMBean();
            String state = bundleState.getState(handle.getBundleId());
            if ("INSTALLED".equals(state)) {
                return 2;
            }
            if ("RESOLVED".equals(state)) {
                return 4;
            }
            if ("STARTING".equals(state)) {
                return 8;
            }
            if ("ACTIVE".equals(state)) {
                return 32;
            }
            if ("STOPPING".equals(state)) {
                return 16;
            }
            if ("UNINSTALLED".equals(state)) {
                return 1;
            }
            throw new IllegalStateException("Unsupported state: " + state);
        }
        catch (Exception ex) {
            Throwable cause;
            Throwable throwable = cause = ex.getCause() != null ? ex.getCause() : ex;
            if (!(cause instanceof InstanceNotFoundException)) {
                log.warning("Cannot get state for bundle: " + (Object)((Object)this), cause);
            }
            return 1;
        }
    }

    public void startBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException {
        try {
            FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
            frameworkMBean.startBundle(handle.getBundleId());
        }
        catch (IOException ex) {
            throw new BundleException("Cannot start bundle: " + handle, (Throwable)ex);
        }
    }

    public void stopBundle(AbstractDeployableContainer.BundleHandle handle) throws BundleException {
        try {
            FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
            frameworkMBean.stopBundle(handle.getBundleId());
        }
        catch (IOException ex) {
            throw new BundleException("Cannot start bundle: " + handle, (Throwable)ex);
        }
    }

    public boolean isBundleInstalled(String symbolicName) {
        try {
            BundleStateMBean bundleStateMBean = this.jmxSupport.getBundleStateMBean();
            TabularData listBundles = bundleStateMBean.listBundles();
            for (CompositeData bundleType : listBundles.values()) {
                String bsn = (String)bundleType.get("SymbolicName");
                if (!bsn.equals(symbolicName)) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    private MBeanServerConnection getMBeanServerConnection() {
        String urlString = System.getProperty("jmx.service.url", "service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi");
        try {
            if (this.jmxConnector == null) {
                log.fine("Connecting JMXConnector to: " + urlString);
                JMXServiceURL serviceURL = new JMXServiceURL(urlString);
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
    }
}

