/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.container.glassfish.embedded_3_1.app;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.IOException;

/**
 * TestServlet
 *
 * @author <a href="mailto:aslak@redhat.com">Aslak Knutsen</a>
 * @version $Revision: $
 */
@WebServlet(urlPatterns = MyServlet.URL_PATTERN)
public class MyServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public static final String URL_PATTERN = "/Test";

    public static final String MESSAGE = "hello";

    @Resource(name = "jdbc/arquillian")
    private DataSource arquillianDS;
    @Resource(name = "jdbc/arquillian2")
    private DataSource arquillianDS2;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().append(areDatasourcesSet() ? MESSAGE : "#fail");
    }

    private boolean areDatasourcesSet() {
        return arquillianDS != null && arquillianDS2 != null;
    }
}