/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.util.ContextName;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.tomcat.embedded.EmbeddedContextConfig;
import org.jboss.arquillian.container.tomcat.embedded.EmbeddedHostConfig;
import org.jboss.arquillian.container.tomcat.embedded.SystemPropertiesUtil;
import org.jboss.arquillian.container.tomcat.embedded.TomcatEmbeddedConfiguration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class Tomcat10EmbeddedContainer
implements DeployableContainer<TomcatEmbeddedConfiguration> {
    private final SystemPropertiesUtil systemPropertiesUtil = new SystemPropertiesUtil();
    private TomcatEmbeddedConfiguration configuration;
    private Tomcat tomcat;
    private Host host;
    private EmbeddedHostConfig embeddedHostConfig;
    private File appBase;
    private boolean wasStarted;
    @Inject
    @DeploymentScoped
    private InstanceProducer<StandardContext> standardContextProducer;

    public Class<TomcatEmbeddedConfiguration> getConfigurationClass() {
        return TomcatEmbeddedConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public void setup(TomcatEmbeddedConfiguration configuration) {
        String serverName = configuration.getServerName();
        if (serverName == null || "".equals(serverName)) {
            configuration.setServerName("arquillian-tomcat-embedded-10");
        }
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.startTomcatEmbedded();
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to start embedded Tomcat", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (this.wasStarted) {
            try {
                this.stopTomcatEmbedded();
            }
            catch (org.apache.catalina.LifecycleException e) {
                throw new LifecycleException("Failed to stop Tomcat", (Throwable)e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            this.deleteWar(archive);
            File archiveFile = new File(this.appBase, archive.getName());
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(archiveFile, true);
            this.embeddedHostConfig.deployWAR(archive.getName());
            ContextName contextName = this.getContextName(archive);
            StandardContext standardContext = (StandardContext)this.host.findChild(contextName.getName());
            this.standardContextProducer.set((Object)standardContext);
            HTTPContext httpContext = new HTTPContext(this.tomcat.getHost().getName(), this.tomcat.getConnector().getLocalPort());
            for (String mapping : standardContext.findServletMappings()) {
                httpContext.add(new Servlet(standardContext.findServletMapping(mapping), contextName.getPath()));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy " + archive.getName(), (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.embeddedHostConfig.undeployWAR(archive.getName());
            this.deleteWar(archive);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void startTomcatEmbedded() throws LifecycleException, org.apache.catalina.LifecycleException {
        File tempDir = this.getTomcatHomeFile();
        System.setProperty("catalina.base", tempDir.getAbsolutePath());
        CatalinaProperties.getProperty((String)"foo");
        this.appBase = new File(tempDir, "webapps");
        if (!this.appBase.exists() && !this.appBase.mkdirs()) {
            throw new LifecycleException("Unable to create appBase " + this.appBase.getAbsolutePath() + " for Tomcat");
        }
        this.tomcat = new Tomcat();
        this.tomcat.getService().setName(this.configuration.getServerName());
        String hostname = this.configuration.getBindAddress();
        this.tomcat.setHostname(hostname);
        this.tomcat.setPort(this.configuration.getBindHttpPort());
        this.tomcat.setBaseDir(tempDir.getAbsolutePath());
        this.tomcat.getConnector();
        this.tomcat.enableNaming();
        this.tomcat.getEngine().setName(this.configuration.getServerName());
        this.host = new StandardHost();
        this.host.setName(hostname);
        this.host.setAppBase(this.appBase.getAbsolutePath());
        this.host.setDeployOnStartup(false);
        this.host.setAutoDeploy(false);
        this.host.setConfigClass(EmbeddedContextConfig.class.getCanonicalName());
        this.embeddedHostConfig = new EmbeddedHostConfig();
        this.embeddedHostConfig.setUnpackWARs(this.configuration.isUnpackArchive());
        this.host.addLifecycleListener((LifecycleListener)this.embeddedHostConfig);
        this.tomcat.getEngine().addChild((Container)this.host);
        this.tomcat.start();
        this.wasStarted = true;
    }

    protected void stopTomcatEmbedded() throws org.apache.catalina.LifecycleException {
        this.tomcat.stop();
        this.tomcat.destroy();
    }

    private void deleteWar(Archive<?> archive) {
        File warFile;
        if (this.configuration.isUnpackArchive()) {
            ContextName contextName = this.getContextName(archive);
            File unpackDir = new File(this.host.getAppBase(), contextName.getBaseName());
            if (unpackDir.exists()) {
                ExpandWar.deleteDir((File)unpackDir);
            }
        }
        if ((warFile = new File(this.host.getAppBase(), archive.getName())).exists()) {
            warFile.delete();
        }
    }

    private File getTomcatHomeFile() throws LifecycleException {
        String tomcatHome = this.configuration.getTomcatHome();
        if (tomcatHome != null) {
            File tomcatHomeFile = new File(this.systemPropertiesUtil.substituteEvironmentVariable(tomcatHome));
            if (!tomcatHomeFile.exists() && !tomcatHomeFile.mkdirs()) {
                throw new LifecycleException("Unable to create home directory for Tomcat");
            }
            tomcatHomeFile.deleteOnExit();
            return tomcatHomeFile;
        }
        try {
            File tomcatHomeFile = File.createTempFile("tomcat-embedded-10", null);
            if (!tomcatHomeFile.delete() || !tomcatHomeFile.mkdirs()) {
                throw new LifecycleException("Unable to create temporary home directory " + tomcatHomeFile.getAbsolutePath() + " for Tomcat");
            }
            tomcatHomeFile.deleteOnExit();
            return tomcatHomeFile;
        }
        catch (IOException e) {
            throw new LifecycleException("Unable to create temporary home directory for Tomcat", (Throwable)e);
        }
    }

    private ContextName getContextName(Archive<?> archive) {
        return new ContextName(archive.getName(), true);
    }
}

