/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded;

import org.jboss.arquillian.container.tomcat.embedded.SystemPropertiesUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SystemPropertiesUtilTest {
    private static final String TEST_KEY = SystemPropertiesUtilTest.class.getName() + ".TEST_KEY";
    private static final String TEST_VALUE = SystemPropertiesUtilTest.class.getName() + ".TEST_VALUE";
    private static final String TEST_NO_ENV_ORIGINAL;
    private static final String TEST_NO_ENV_EXPECTED;
    private static final String TEST_ENV_ORIGINAL;
    private static final String TEST_ENV_EXPECTED;
    private static final SystemPropertiesUtil systemPropertiesUtil;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty(TEST_KEY, TEST_VALUE);
    }

    @Test
    public void testSubstituteEvironmentVariableForNoVariable() {
        this.testSubstituteEnvironmentVariable(TEST_NO_ENV_ORIGINAL, TEST_NO_ENV_EXPECTED);
    }

    @Test
    public void testSubstituteEvironmentVariableForOnlyVariable() {
        this.testSubstituteEnvironmentVariable(TEST_ENV_ORIGINAL, TEST_ENV_EXPECTED);
    }

    private void testSubstituteEnvironmentVariable(String original, String expected) {
        String actual = systemPropertiesUtil.substituteEvironmentVariable(original);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    static {
        TEST_NO_ENV_EXPECTED = TEST_NO_ENV_ORIGINAL = TEST_KEY;
        TEST_ENV_ORIGINAL = "${env." + TEST_KEY + "}";
        TEST_ENV_EXPECTED = TEST_VALUE;
        systemPropertiesUtil = new SystemPropertiesUtil();
    }
}

