/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.BeanDeploymentArchiveImpl;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.FlatDeployment;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockLifecycle;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContainer {
    private final MockLifecycle lifecycle;
    private final Deployment deployment;

    public TestContainer(BeansXml beansXml, Collection<Class<?>> classes) {
        this(new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beansXml, classes)));
    }

    public TestContainer(Collection<URL> beansXml, Collection<Class<?>> classes) {
        this.lifecycle = new MockLifecycle();
        this.deployment = new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(this.lifecycle.getBootstrap().parse(beansXml), classes));
    }

    public TestContainer(String beanArchiveId, Collection<URL> beansXml, Collection<Class<?>> classes) {
        this.lifecycle = new MockLifecycle();
        this.deployment = new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beanArchiveId, this.lifecycle.getBootstrap().parse(beansXml), classes));
    }

    public TestContainer(BeansXml beansXml, Class<?> ... classes) {
        this(new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(beansXml, Arrays.asList(classes))));
    }

    public TestContainer(Class<?> ... classes) {
        this(new FlatDeployment((BeanDeploymentArchive)new BeanDeploymentArchiveImpl(Arrays.asList(classes))));
    }

    public TestContainer(Deployment deployment) {
        this.deployment = deployment;
        this.lifecycle = new MockLifecycle();
    }

    public TestContainer ensureRequestActive() {
        if (!this.getLifecycle().isSessionActive()) {
            this.getLifecycle().beginSession();
        }
        if (!this.getLifecycle().isConversationActive()) {
            ((ConversationContext)this.getLifecycle().getConversationContext()).setActive(true);
        }
        if (!this.getLifecycle().isRequestActive()) {
            this.getLifecycle().beginRequest();
        }
        return this;
    }

    public TestContainer startContainer() {
        this.getLifecycle().initialize(this.deployment);
        this.getLifecycle().beginApplication();
        return this;
    }

    public MockLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public WeldManager getBeanManager(BeanDeploymentArchive beanDeploymentArchive) {
        return this.getLifecycle().getBootstrap().getManager(beanDeploymentArchive);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public TestContainer stopContainer() {
        if (this.getLifecycle().isRequestActive()) {
            this.getLifecycle().endRequest();
        }
        if (this.getLifecycle().isConversationActive()) {
            ((ConversationContext)this.getLifecycle().getConversationContext()).setActive(false);
        }
        if (this.getLifecycle().isSessionActive()) {
            this.getLifecycle().endSession();
        }
        if (this.getLifecycle().isApplicationActive()) {
            this.getLifecycle().endApplication();
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Runner {
        private static Runnable NO_OP = new Runnable(){

            public void run(WeldManager beanManager) {
            }
        };
        private final List<URL> beansXml;
        private final List<Class<?>> classes;

        public Runner(List<URL> beansXml, List<Class<?>> classes) {
            this.beansXml = beansXml;
            this.classes = classes;
        }

        public void run() throws Exception {
            this.run(NO_OP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable runnable) throws Exception {
            TestContainer container = null;
            try {
                container = new TestContainer(this.beansXml, this.classes);
                container.startContainer().ensureRequestActive();
                runnable.run(container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next()));
            }
            finally {
                if (container != null) {
                    container.stopContainer();
                }
            }
        }

        public void runAndExpect(Exception expected) {
            this.runAndExpect(NO_OP, expected);
        }

        public void runAndExpect(Runnable runnable, Exception expected) {
            block4: {
                try {
                    this.run();
                }
                catch (Exception e) {
                    if (!expected.getClass().isAssignableFrom(e.getClass())) {
                        AssertionError t = new AssertionError((Object)("Expected exception " + expected + " but got " + e));
                        ((Throwable)((Object)t)).initCause(e);
                        throw t;
                    }
                    if (expected.getMessage() == null) {
                        return;
                    }
                    String errorCode = expected.getMessage().substring(0, 11);
                    if (!e.getMessage().startsWith(errorCode)) break block4;
                    return;
                }
            }
            throw new AssertionError((Object)("Expected exception " + expected + " but none was thrown"));
        }

        public static interface Runnable {
            public void run(WeldManager var1);
        }
    }
}

