/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.http.HttpSession;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.CDISessionID;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.ContextClassLoaderManager;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.ConversationLifeCycleCreator;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.ConversationLifeCycleDestoryer;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.RequestLifeCycleCreator;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.RequestLifeCycleDestroyer;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.SessionLifeCycleCreator;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.SessionLifeCycleDestoryer;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.Utils;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.WeldEEMockConfiguration;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockHttpSession;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.MockServletContext;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.TestContainer;
import org.jboss.arquillian.protocol.local.LocalMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.event.container.AfterDeploy;
import org.jboss.arquillian.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.TestEvent;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.classloader.ShrinkWrapClassLoader;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.HttpSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldEEMockContainer
implements DeployableContainer {
    public void setup(Context context, Configuration configuration) {
    }

    public void start(Context context) throws LifecycleException {
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        boolean enableConversation = ((WeldEEMockConfiguration)((Configuration)context.get(Configuration.class)).getContainerConfig(WeldEEMockConfiguration.class)).isEnableConversationScope();
        ShrinkWrapClassLoader classLoader = new ShrinkWrapClassLoader(archive.getClass().getClassLoader(), new Archive[]{archive});
        ContextClassLoaderManager classLoaderManager = new ContextClassLoaderManager(classLoader);
        classLoaderManager.enable();
        TestContainer container = new TestContainer(Utils.findArchiveId(archive), Utils.findBeansXml(archive), Utils.findBeanClasses(archive, (ClassLoader)classLoader));
        Bootstrap bootstrap = container.getLifecycle().getBootstrap();
        context.add(ContextClassLoaderManager.class, (Object)classLoaderManager);
        container.startContainer();
        context.add(TestContainer.class, (Object)container);
        context.add(Bootstrap.class, (Object)bootstrap);
        context.add(WeldManager.class, (Object)container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next()));
        context.register(AfterDeploy.class, (EventHandler)new SessionLifeCycleCreator());
        context.register(BeforeUnDeploy.class, (EventHandler)new SessionLifeCycleDestoryer());
        context.register(Before.class, (EventHandler)new RequestLifeCycleCreator());
        context.register(Before.class, (EventHandler)new EventHandler<TestEvent>(){
            private Map<String, HttpSession> sessionStore = new HashMap<String, HttpSession>();

            public void callback(Context context, TestEvent event) throws Exception {
                WeldManager manager = (WeldManager)context.get(WeldManager.class);
                CDISessionID id = (CDISessionID)context.get(CDISessionID.class);
                if (id != null) {
                    HttpSessionManager sessionManager = Utils.getBeanReference((BeanManager)manager, HttpSessionManager.class);
                    HttpSession session = this.sessionStore.get(id.getId());
                    if (session == null) {
                        session = new MockHttpSession(id.getId(), new MockServletContext("/"));
                    }
                    sessionManager.setSession(session);
                    this.sessionStore.put(id.getId(), session);
                }
            }
        });
        if (enableConversation) {
            context.register(Before.class, (EventHandler)new ConversationLifeCycleCreator());
            context.register(After.class, (EventHandler)new ConversationLifeCycleDestoryer());
        }
        context.register(After.class, (EventHandler)new RequestLifeCycleDestroyer());
        return new LocalMethodExecutor();
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        TestContainer container = (TestContainer)context.get(TestContainer.class);
        if (container != null) {
            container.stopContainer();
        }
        ContextClassLoaderManager classLoaderManager = (ContextClassLoaderManager)context.get(ContextClassLoaderManager.class);
        classLoaderManager.disable();
    }

    public void stop(Context context) throws LifecycleException {
    }
}

