/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.managed;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.container.se.api.CompositeArchive;
import org.jboss.arquillian.container.se.managed.ManagedSEContainerConfiguration;
import org.jboss.arquillian.container.se.managed.util.ServerAwait;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class ManagedSEDeployableContainer
implements DeployableContainer<ManagedSEContainerConfiguration> {
    private static final Logger log = Logger.getLogger(ManagedSEDeployableContainer.class.getName());
    private static final String SYSPROP_KEY_JAVA_HOME = "java.home";
    private static final String X_DEBUG = "-Xdebug";
    private static final String DEBUG_AGENT_STRING = "-Xrunjdwp:server=y,transport=dt_socket,address=8787,suspend=y";
    private static final String TARGET = "target";
    private static final String SERVER_MAIN_CLASS_FQN = "org.jboss.arquillian.container.se.server.Main";
    private boolean debugModeEnabled;
    private Process process;
    private List<File> materializedTestDeployments;
    private List<File> dependenciesJars;
    private String host;
    private int port;
    private String librariesPath;

    public Class<ManagedSEContainerConfiguration> getConfigurationClass() {
        return ManagedSEContainerConfiguration.class;
    }

    public void setup(ManagedSEContainerConfiguration configuration) {
        this.debugModeEnabled = configuration.isDebug();
        this.host = configuration.getHost();
        this.port = configuration.getPort();
        this.materializedTestDeployments = new ArrayList<File>();
        this.dependenciesJars = new ArrayList<File>();
        this.librariesPath = configuration.getLibrariesPath();
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("simple-jmx");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        log.info("Undeploying " + archive.getName());
        for (File materializedDeployment : this.materializedTestDeployments) {
            materializedDeployment.delete();
        }
        this.materializedTestDeployments = new ArrayList<File>();
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new RuntimeException("Interrupted while awaiting server daemon process termination", e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        log.info("Deploying " + archive.getName());
        if (archive instanceof CompositeArchive) {
            CompositeArchive composite = (CompositeArchive)archive;
            for (Archive item : composite.getItems()) {
                this.materializeArchive(item);
            }
        } else {
            this.materializeArchive(archive);
        }
        this.readJarFilesFromDirectory();
        List<String> processCommand = this.buildProcessCommand();
        ProcessBuilder processBuilder = new ProcessBuilder(processCommand);
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        try {
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not start process", (Throwable)e);
        }
        int waitTime = this.debugModeEnabled ? 15 : 5;
        boolean connected = this.serverAwait(this.host, this.port, waitTime);
        if (!connected) {
            throw new DeploymentException("Child JVM process failed to start within " + waitTime + " seconds.");
        }
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        protocolMetaData.addContext((Object)new JMXContext(this.host, this.port));
        return protocolMetaData;
    }

    private boolean serverAwait(String host, int port, int waitTime) {
        ServerAwait serverAwait = new ServerAwait(host, port, waitTime);
        return serverAwait.run();
    }

    private void materializeArchive(Archive<?> archive) {
        File deploymentFile = new File(TARGET.concat(File.separator).concat(archive.getName()));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deploymentFile);
        this.materializedTestDeployments.add(deploymentFile);
    }

    private List<String> buildProcessCommand() {
        ArrayList<String> command = new ArrayList<String>();
        File javaHome = new File(System.getProperty(SYSPROP_KEY_JAVA_HOME));
        command.add(javaHome.getAbsolutePath() + File.separator + "bin" + File.separator + "java");
        command.add("-cp");
        StringBuilder builder = new StringBuilder();
        for (File materializedDeployment : this.materializedTestDeployments) {
            builder.append(File.pathSeparator + TARGET + File.separator + materializedDeployment.getName());
        }
        for (File dependencyJar : this.dependenciesJars) {
            builder.append(File.pathSeparator + dependencyJar.getPath());
        }
        command.add(builder.toString());
        command.add("-Dcom.sun.management.jmxremote");
        command.add("-Dcom.sun.management.jmxremote.port=" + this.port);
        command.add("-Dcom.sun.management.jmxremote.authenticate=false");
        command.add("-Dcom.sun.management.jmxremote.ssl=false");
        if (this.debugModeEnabled) {
            command.add(X_DEBUG);
            command.add(DEBUG_AGENT_STRING);
        }
        command.add(SERVER_MAIN_CLASS_FQN);
        return command;
    }

    private void readJarFilesFromDirectory() throws DeploymentException {
        if (this.librariesPath == null) {
            return;
        }
        File lib = new File(this.librariesPath);
        if (!lib.exists() || lib.isFile()) {
            throw new DeploymentException("Cannot read files from " + this.librariesPath);
        }
        File[] dep = lib.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        this.dependenciesJars.addAll(Arrays.asList(dep));
    }
}

