/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.managed;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.se.managed.ManagedSEContainerConfiguration;
import org.jboss.arquillian.container.se.managed.util.ServerAwait;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class ManagedSEDeployableContainer
implements DeployableContainer<ManagedSEContainerConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(ManagedSEDeployableContainer.class.getName());
    private static final String SYSPROP_KEY_JAVA_HOME = "java.home";
    private static final String DEBUG_AGENT_STRING = "-agentlib:jdwp=transport=dt_socket,address=8787,server=y,suspend=y";
    private static final String TARGET = "target";
    private static final String SERVER_MAIN_CLASS_FQN = "org.jboss.arquillian.container.se.server.Main";
    private static final String SYSTEM_PROPERTY_SWITCH = "-D";
    private static final String EQUALS = "=";
    private boolean debugModeEnabled;
    private boolean keepDeploymentArchives;
    private Process process;
    private List<File> materializedTestDeployments;
    private List<File> dependenciesJars;
    private String host;
    private int port;
    private String librariesPath;
    private List<String> additionalJavaOpts;

    public Class<ManagedSEContainerConfiguration> getConfigurationClass() {
        return ManagedSEContainerConfiguration.class;
    }

    public void setup(ManagedSEContainerConfiguration configuration) {
        this.debugModeEnabled = configuration.isDebug();
        this.host = configuration.getHost();
        this.port = configuration.getPort();
        this.materializedTestDeployments = new ArrayList<File>();
        this.dependenciesJars = new ArrayList<File>();
        this.librariesPath = configuration.getLibrariesPath();
        this.keepDeploymentArchives = configuration.isKeepDeploymentArchives();
        this.additionalJavaOpts = this.initAdditionalJavaOpts(configuration.getAdditionalJavaOpts());
        this.configureLogging(configuration);
    }

    private List<String> initAdditionalJavaOpts(String opts) {
        if (opts == null || opts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> additionalOpts = new ArrayList<String>();
        for (String option : opts.split("\\s+")) {
            additionalOpts.add(option);
        }
        return additionalOpts;
    }

    private void configureLogging(ManagedSEContainerConfiguration configuration) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(configuration.getLogLevel());
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(consoleHandler);
        LOGGER.setLevel(configuration.getLogLevel());
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("simple-jmx");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        LOGGER.info("Undeploying " + archive.getName());
        if (!this.keepDeploymentArchives) {
            for (File materializedDeployment : this.materializedTestDeployments) {
                materializedDeployment.delete();
            }
        }
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new RuntimeException("Interrupted while awaiting server daemon process termination", e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        LOGGER.info("Deploying " + archive.getName());
        if (ClassPath.isRepresentedBy(archive)) {
            for (Node child : archive.get("/").getChildren()) {
                if (!(child.getAsset() instanceof ArchiveAsset)) continue;
                ArchiveAsset archiveAsset = (ArchiveAsset)child.getAsset();
                this.materializeArchive(archiveAsset.getArchive());
            }
        } else {
            this.materializeArchive(archive);
        }
        Properties systemProperties = this.getSystemProperties(archive);
        this.readJarFilesFromDirectory();
        List<String> processCommand = this.buildProcessCommand(systemProperties);
        this.logExecutedCommand(processCommand);
        ProcessBuilder processBuilder = new ProcessBuilder(processCommand);
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        try {
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not start process", (Throwable)e);
        }
        int waitTime = this.debugModeEnabled ? 15 : 5;
        boolean connected = this.serverAwait(this.host, this.port, waitTime);
        if (!connected) {
            throw new DeploymentException("Child JVM process failed to start within " + waitTime + " seconds.");
        }
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        protocolMetaData.addContext((Object)new JMXContext(this.host, this.port));
        return protocolMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getSystemProperties(Archive<?> archive) throws DeploymentException {
        Node systemPropertiesNode = archive.get(ClassPath.SYSTEM_PROPERTIES_ARCHIVE_PATH);
        if (systemPropertiesNode == null) return null;
        try (InputStream in = systemPropertiesNode.getAsset().openStream();){
            Properties systemProperties = new Properties();
            systemProperties.load(in);
            Properties properties = systemProperties;
            return properties;
        }
        catch (IOException e) {
            throw new DeploymentException("Could not load system properties", (Throwable)e);
        }
    }

    private boolean serverAwait(String host, int port, int waitTime) {
        ServerAwait serverAwait = new ServerAwait(host, port, waitTime);
        return serverAwait.run();
    }

    private void materializeArchive(Archive<?> archive) {
        File deploymentFile = new File(TARGET.concat(File.separator).concat(archive.getName()));
        if (!deploymentFile.exists()) {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deploymentFile);
        }
        this.materializedTestDeployments.add(deploymentFile);
    }

    private List<String> buildProcessCommand(Properties properties) {
        ArrayList<String> command = new ArrayList<String>();
        File javaHome = new File(System.getProperty(SYSPROP_KEY_JAVA_HOME));
        command.add(javaHome.getAbsolutePath() + File.separator + "bin" + File.separator + "java");
        command.add("-cp");
        StringBuilder builder = new StringBuilder();
        for (File file : this.materializedTestDeployments) {
            builder.append(File.pathSeparator + TARGET + File.separator + file.getName());
        }
        for (File file : this.dependenciesJars) {
            builder.append(File.pathSeparator + file.getPath());
        }
        command.add(builder.toString());
        command.add("-Dcom.sun.management.jmxremote");
        command.add("-Dcom.sun.management.jmxremote.port=" + this.port);
        command.add("-Dcom.sun.management.jmxremote.authenticate=false");
        command.add("-Dcom.sun.management.jmxremote.ssl=false");
        if (this.debugModeEnabled) {
            command.add(DEBUG_AGENT_STRING);
        }
        for (String string : this.additionalJavaOpts) {
            command.add(string);
        }
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                this.addSystemProperty(command, entry.getKey().toString(), entry.getValue().toString());
            }
        }
        command.add(SERVER_MAIN_CLASS_FQN);
        return command;
    }

    private void addSystemProperty(List<String> command, String key, String value) {
        command.add(SYSTEM_PROPERTY_SWITCH + key + EQUALS + value);
    }

    private void readJarFilesFromDirectory() throws DeploymentException {
        if (this.librariesPath == null) {
            return;
        }
        File lib = new File(this.librariesPath);
        if (!lib.exists() || lib.isFile()) {
            throw new DeploymentException("Cannot read files from " + this.librariesPath);
        }
        File[] dep = lib.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        this.dependenciesJars.addAll(Arrays.asList(dep));
    }

    private void logExecutedCommand(List<String> processCommand) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder();
            for (String s : processCommand) {
                builder.append(s);
                builder.append(" ");
            }
            LOGGER.log(Level.FINE, "Executing command: " + builder);
        }
    }
}

