/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.protocol.arquillian;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DaemonDeploymentPackager implements DeploymentPackager
{
    INSTANCE;

    private static final Logger log;

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        JavaArchive archive = (JavaArchive)testDeployment.getApplicationArchive().as(JavaArchive.class);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive before additional packaging: " + archive.toString(true));
        }
        for (Archive auxArchive : testDeployment.getAuxiliaryArchives()) {
            archive.merge(auxArchive);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive after additional packaging: " + archive.toString(true));
        }
        return archive;
    }

    static {
        log = Logger.getLogger(DaemonDeploymentPackager.class.getName());
    }
}

