/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.daemon.server.Server;
import org.jboss.arquillian.daemon.server.ServerBase;
import org.jboss.arquillian.daemon.server.ServerLifecycleException;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

final class NettyServer
extends ServerBase
implements Server {
    private static final Logger log = Logger.getLogger(NettyServer.class.getName());
    private static final EofDecoder EOF_DECODER;
    private static final String NAME_CHANNEL_HANDLER_EOF = "EOFHandler";
    private static final String NAME_CHANNEL_HANDLER_ACTION_CONTROLLER = "ActionControllerHandler";
    private static final String NAME_CHANNEL_HANDLER_STRING_DECODER = "StringDecoder";
    private static final String NAME_CHANNEL_HANDLER_FRAME_DECODER = "FrameDecoder";
    private static final String NAME_CHANNEL_HANDLER_DEPLOY_HANDLER = "DeployHandler";
    private static final String NAME_CHANNEL_HANDLER_COMMAND = "CommandHandler";
    private static final String[] NAME_CHANNEL_HANDLERS;
    private ServerBootstrap bootstrap;

    NettyServer(InetSocketAddress bindAddress) {
        super(bindAddress);
    }

    protected void startInternal() throws ServerLifecycleException, IllegalStateException {
        ChannelFuture openChannel;
        ServerBootstrap bootstrap;
        this.bootstrap = bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class).localAddress((SocketAddress)this.getBindAddress())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                NettyServer.this.resetPipeline(pipeline);
            }
        }).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            openChannel = bootstrap.bind().sync();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ServerLifecycleException("Interrupted while awaiting server start", ie);
        }
        catch (RuntimeException re) {
            throw new ServerLifecycleException("Encountered error in binding; could not start server.", re);
        }
        InetSocketAddress boundAddress = (InetSocketAddress)openChannel.channel().localAddress();
        this.setBoundAddress(boundAddress);
    }

    protected void stopInternal() throws ServerLifecycleException, IllegalStateException {
        this.bootstrap.shutdown();
    }

    private void resetPipeline(ChannelPipeline pipeline) {
        for (String handlerName : NAME_CHANNEL_HANDLERS) {
            try {
                pipeline.remove(handlerName);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        pipeline.addLast(NAME_CHANNEL_HANDLER_EOF, (ChannelHandler)EOF_DECODER);
        pipeline.addLast(NAME_CHANNEL_HANDLER_ACTION_CONTROLLER, (ChannelHandler)new ActionControllerHandler());
    }

    private static void sendResponse(ChannelHandlerContext ctx, ByteBuf out, String response) {
        out.discardReadBytes();
        try {
            out.writeBytes(response.getBytes("UTF-8"));
            out.writeBytes(Delimiters.lineDelimiter()[0]);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding", uee);
        }
        ctx.flush();
    }

    static {
        try {
            EOF_DECODER = new EofDecoder();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not get encoding: UTF-8", e);
        }
        NAME_CHANNEL_HANDLERS = new String[]{NAME_CHANNEL_HANDLER_EOF, NAME_CHANNEL_HANDLER_ACTION_CONTROLLER, NAME_CHANNEL_HANDLER_STRING_DECODER, NAME_CHANNEL_HANDLER_FRAME_DECODER, NAME_CHANNEL_HANDLER_DEPLOY_HANDLER, NAME_CHANNEL_HANDLER_COMMAND};
    }

    @ChannelHandler.Sharable
    private static final class EofDecoder
    extends DelimiterBasedFrameDecoder {
        public EofDecoder() throws UnsupportedEncodingException {
            super(Integer.MAX_VALUE, true, Unpooled.wrappedBuffer((byte[])"<<EOF".getBytes("UTF-8")));
        }
    }

    private final class ActionControllerHandler
    extends ChannelInboundByteHandlerAdapter {
        private ActionControllerHandler() {
        }

        public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            short magic3;
            short magic2;
            if (in.readableBytes() < 3) {
                return;
            }
            ChannelPipeline pipeline = ctx.pipeline();
            int readerIndex = in.readerIndex();
            short magic1 = in.getUnsignedByte(readerIndex);
            if (this.isStringCommand(magic1, magic2 = in.getUnsignedByte(readerIndex + 1), magic3 = in.getUnsignedByte(readerIndex + 2))) {
                in.writeBytes(Delimiters.lineDelimiter()[0]);
                pipeline.addLast(NettyServer.NAME_CHANNEL_HANDLER_FRAME_DECODER, (ChannelHandler)new DelimiterBasedFrameDecoder(2000, Delimiters.lineDelimiter()));
                pipeline.addLast(NettyServer.NAME_CHANNEL_HANDLER_STRING_DECODER, (ChannelHandler)new StringDecoder(Charset.forName("UTF-8")));
                pipeline.addLast(NettyServer.NAME_CHANNEL_HANDLER_COMMAND, (ChannelHandler)new StringCommandHandler());
                pipeline.remove(NettyServer.NAME_CHANNEL_HANDLER_ACTION_CONTROLLER);
                pipeline.remove(NettyServer.NAME_CHANNEL_HANDLER_EOF);
            } else if (this.isDeployCommand(magic1, magic2, magic3)) {
                in.readerIndex(in.readerIndex() + "DPL ".length());
                pipeline.addLast(NettyServer.NAME_CHANNEL_HANDLER_DEPLOY_HANDLER, (ChannelHandler)new DeployHandlerAdapter());
                pipeline.remove(NettyServer.NAME_CHANNEL_HANDLER_ACTION_CONTROLLER);
                pipeline.remove(NettyServer.NAME_CHANNEL_HANDLER_EOF);
            } else {
                NettyServer.sendResponse(ctx, ctx.nextOutboundByteBuffer(), "ERR Unsupported Command");
                in.clear();
                ctx.close();
                return;
            }
            ByteBuf nextInboundByteBuffer = ctx.nextInboundByteBuffer();
            nextInboundByteBuffer.writeBytes(in);
            pipeline.fireInboundBufferUpdated();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyServer.sendResponse(ctx, ctx.nextOutboundByteBuffer(), cause.getMessage());
        }

        private boolean isStringCommand(int magic1, int magic2, int magic3) {
            return magic1 == "CMD ".charAt(0) && magic2 == "CMD ".charAt(1) && magic3 == "CMD ".charAt(2);
        }

        private boolean isDeployCommand(int magic1, int magic2, int magic3) {
            return magic1 == "DPL ".charAt(0) && magic2 == "DPL ".charAt(1) && magic3 == "DPL ".charAt(2);
        }
    }

    private final class DeployHandlerAdapter
    extends ChannelInboundByteHandlerAdapter {
        private DeployHandlerAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Using the " + ((Object)((Object)this)).getClass().getSimpleName());
            }
            try {
                ByteBufInputStream instream = new ByteBufInputStream(in);
                GenericArchive archive = (GenericArchive)((ZipImporter)((ZipImporter)NettyServer.this.getShrinkwrapDomain().getArchiveFactory().create(ZipImporter.class)).importFrom((InputStream)instream)).as(GenericArchive.class);
                instream.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Got archive: " + archive.toString(true));
                }
                String id = archive.getId();
                NettyServer.this.getDeployedArchives().put(id, archive);
                ByteBuf out = ctx.nextOutboundByteBuffer();
                NettyServer.sendResponse(ctx, out, "OK DPL " + id);
            }
            finally {
                NettyServer.this.resetPipeline(ctx.pipeline());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringCommandHandler
    extends ChannelInboundMessageHandlerAdapter<String> {
        private StringCommandHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, String message) throws Exception {
            block14: {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Got command: " + message);
                }
                ByteBuf out = ctx.nextOutboundByteBuffer();
                try {
                    ChannelPipeline pipeline = ctx.pipeline();
                    NettyServer.this.resetPipeline(pipeline);
                    if ("CMD stop".equals(message)) {
                        NettyServer.sendResponse(ctx, out, "OK " + message);
                        NettyServer.this.stopAsync();
                        break block14;
                    }
                    if (message.startsWith("CMD undeploy ")) {
                        GenericArchive removedArchive;
                        String deploymentName = message.substring("CMD undeploy ".length()).trim();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Requesting undeployment of: " + deploymentName);
                        }
                        if ((removedArchive = (GenericArchive)NettyServer.this.getDeployedArchives().remove(deploymentName)) == null) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Not current deployment: " + deploymentName);
                            }
                            String response = "ERR Deployment " + deploymentName + " could not be found in current deployments.";
                            NettyServer.sendResponse(ctx, out, response);
                            return;
                        }
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Undeployed: " + deploymentName);
                        }
                        String response = "OK " + deploymentName;
                        NettyServer.sendResponse(ctx, out, response);
                        break block14;
                    }
                    if (message.startsWith("CMD test ")) {
                        StringTokenizer tokenizer = new StringTokenizer(message);
                        tokenizer.nextToken();
                        tokenizer.nextToken();
                        String archiveId = tokenizer.nextToken();
                        String testClassName = tokenizer.nextToken();
                        String methodName = tokenizer.nextToken();
                        Serializable testResult = NettyServer.this.executeTest(archiveId, testClassName, methodName);
                        ObjectOutputStream objectOutstream = null;
                        try {
                            out.discardReadBytes();
                            objectOutstream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(out));
                            objectOutstream.writeObject(testResult);
                            objectOutstream.flush();
                            ctx.flush();
                            return;
                        }
                        finally {
                            if (objectOutstream != null) {
                                objectOutstream.close();
                            }
                        }
                    }
                    throw new UnsupportedOperationException("This server does not support command: " + message);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    NettyServer.sendResponse(ctx, out, "ERR Caught unexpected error servicing request: " + t.getMessage());
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!NettyServer.this.isRunning()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Got exception while server is not running: " + cause.getMessage());
                }
                ctx.close();
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }
    }
}

