/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.arquillian.daemon.server.NettyServer;
import org.jboss.arquillian.daemon.server.Server;
import org.jboss.arquillian.daemon.server.ServerLifecycleException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerBase
implements Server {
    private static final Logger log = Logger.getLogger(ServerBase.class.getName());
    private static final String CLASS_NAME_ARQ_TEST_RUNNERS = "org.jboss.arquillian.container.test.spi.util.TestRunners";
    private static final String METHOD_NAME_GET_TEST_RUNNER = "getTestRunner";
    private static final String METHOD_NAME_EXECUTE = "execute";
    private ExecutorService shutdownService;
    private boolean running;
    private InetSocketAddress boundAddress;
    private final InetSocketAddress bindAddress;
    private final ConcurrentMap<String, GenericArchive> deployedArchives;
    private final Domain shrinkwrapDomain;

    public ServerBase(InetSocketAddress bindAddress) {
        assert (bindAddress != null) : "Bind address must be specified";
        ClassLoader thisCl = NettyServer.class.getClassLoader();
        HashSet<ClassLoader> classloaders = new HashSet<ClassLoader>(1);
        classloaders.add(thisCl);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Using ClassLoader for ShrinkWrap Domain: " + thisCl);
        }
        Domain shrinkwrapDomain = ShrinkWrap.createDomain((ConfigurationBuilder)new ConfigurationBuilder().classLoaders(classloaders));
        this.bindAddress = bindAddress;
        this.deployedArchives = new ConcurrentHashMap<String, GenericArchive>();
        this.shrinkwrapDomain = shrinkwrapDomain;
    }

    protected abstract void startInternal() throws ServerLifecycleException, IllegalStateException;

    protected abstract void stopInternal() throws ServerLifecycleException, IllegalStateException;

    @Override
    public final void start() throws ServerLifecycleException, IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Already running");
        }
        this.startInternal();
        this.running = true;
        this.shutdownService = Executors.newSingleThreadExecutor();
        if (log.isLoggable(Level.INFO)) {
            log.info("Server started on " + this.boundAddress.getHostName() + ":" + this.boundAddress.getPort());
        }
    }

    @Override
    public final void stop() throws ServerLifecycleException, IllegalStateException {
        Logger log = Logger.getAnonymousLogger();
        log.addHandler(new Handler(){
            private final String PREFIX = "[" + NettyServer.class.getSimpleName() + "] ";

            public void publish(LogRecord record) {
                System.out.println(this.PREFIX + record.getMessage());
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        });
        if (!this.isRunning()) {
            throw new IllegalStateException("Server is not running");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Requesting shutdown...");
        }
        this.stopInternal();
        this.shutdownService.shutdownNow();
        this.shutdownService = null;
        this.running = false;
        this.boundAddress = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Server shutdown.");
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    protected final InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public final InetSocketAddress getBoundAddress() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Server is not running");
        }
        return this.boundAddress;
    }

    protected final void setBoundAddress(InetSocketAddress boundAddress) {
        this.boundAddress = boundAddress;
    }

    protected final ConcurrentMap<String, GenericArchive> getDeployedArchives() {
        return this.deployedArchives;
    }

    protected final Domain getShrinkwrapDomain() {
        return this.shrinkwrapDomain;
    }

    protected final Serializable executeTest(String archiveId, String testClassName, String methodName) throws IllegalStateException {
        GenericArchive archive = (GenericArchive)this.getDeployedArchives().get(archiveId);
        if (archive == null) {
            throw new IllegalStateException("Archive with ID " + archiveId + " is not deployed");
        }
        ShrinkWrapClassLoader isolatedArchiveCL = new ShrinkWrapClassLoader((ClassLoader)null, new Archive[]{archive});
        ClassLoader oldCl = SecurityActions.getTccl();
        ObjectOutputStream objectOutstream = null;
        try {
            Serializable testResult;
            Class testRunnersClass;
            Class testClass;
            SecurityActions.setTccl((ClassLoader)isolatedArchiveCL);
            try {
                testClass = isolatedArchiveCL.loadClass(testClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class " + testClassName + " from deployed archive: " + archive.toString());
            }
            try {
                testRunnersClass = isolatedArchiveCL.loadClass(CLASS_NAME_ARQ_TEST_RUNNERS);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class org.jboss.arquillian.container.test.spi.util.TestRunners from deployed archive: " + archive.toString());
            }
            Method getTestRunnerMethod = testRunnersClass.getMethod(METHOD_NAME_GET_TEST_RUNNER, ClassLoader.class);
            Object testRunner = getTestRunnerMethod.invoke(null, isolatedArchiveCL);
            Class<?> testRunnerClass = testRunner.getClass();
            Method executeMethod = testRunnerClass.getMethod(METHOD_NAME_EXECUTE, Class.class, String.class);
            Serializable serializable = testResult = (Serializable)executeMethod.invoke(testRunner, testClass, methodName);
            return serializable;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        finally {
            SecurityActions.setTccl(oldCl);
            try {
                isolatedArchiveCL.close();
            }
            catch (IOException iOException) {}
            if (objectOutstream != null) {
                try {
                    objectOutstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final void stopAsync() {
        this.shutdownService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ServerBase.this.stop();
                return null;
            }
        });
    }

    private static final class SecurityActions {
        private SecurityActions() {
            throw new UnsupportedOperationException("No instances");
        }

        static ClassLoader getTccl() {
            if (System.getSecurityManager() == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return AccessController.doPrivileged(GetTcclAction.INSTANCE);
        }

        static void setTccl(final ClassLoader cl) {
            assert (cl != null) : "ClassLoader must be specified";
            if (System.getSecurityManager() == null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
        {
            INSTANCE;


            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }
}

