/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.android.configuration;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.android.configuration.SecurityActions;
import org.jboss.arquillian.android.configuration.Validate;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMapper {
    public static <T> T fromArquillianDescriptor(ArquillianDescriptor descriptor, T configuration, Map<String, String> properties) {
        Validate.notNull(descriptor, "Descriptor must not be null");
        Validate.notNull(configuration, "Configuration must not be null");
        List<Field> fields = SecurityActions.getAccessableFields(configuration.getClass());
        for (Field f : fields) {
            if (!properties.containsKey(f.getName())) continue;
            try {
                f.set(configuration, ConfigurationMapper.convert(ConfigurationMapper.box(f.getType()), properties.get(f.getName())));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Android configuration from Arquillian Descriptor", e);
            }
        }
        return configuration;
    }

    private static Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    private static <T> T convert(Class<T> clazz, String value) {
        if (String.class.equals(clazz)) {
            return clazz.cast(value);
        }
        if (Integer.class.equals(clazz)) {
            return clazz.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(clazz)) {
            return clazz.cast(Double.valueOf(value));
        }
        if (Long.class.equals(clazz)) {
            return clazz.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(clazz)) {
            return clazz.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (File.class.equals(clazz)) {
            try {
                return clazz.cast(new File(value));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to File", e);
            }
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + clazz.getName());
    }
}

