/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.android.configuration;

import java.io.File;

class Validate {
    Validate() {
    }

    public static void stateNotNull(Object object, String message) throws IllegalStateException {
        if (object == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNull(Object obj, String message) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isReadable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        Validate.isReadable(file, message);
    }

    public static void isReadable(File file, String message) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException(message);
        }
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isReadableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        Validate.isReadableDirectory(file, message);
    }

    public static void isReadableDirectory(File file, String message) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException(message);
        }
        if (!(file.exists() && file.isDirectory() && file.canRead() && file.canExecute())) {
            throw new IllegalArgumentException(message);
        }
    }
}

