/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.browserstack.extension.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class BrowserStackDriver
extends RemoteWebDriver {
    private static final Logger log = Logger.getLogger(BrowserStackDriver.class.getName());
    private boolean isSetBrowserStackLocal;
    private boolean isSetBrowserStackLocalManaged;

    public BrowserStackDriver(URL url, Capabilities capabilities, boolean isSetBrowserStackLocal, boolean isSetBrowserStackLocalManaged) {
        super(url, capabilities);
        this.isSetBrowserStackLocal = isSetBrowserStackLocal;
        this.isSetBrowserStackLocalManaged = isSetBrowserStackLocalManaged;
    }

    public void get(String url) {
        String host = null;
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            log.warning("The url " + url + " has been detected as a malformed URL. The message of the exception: " + e.getMessage());
        }
        if (host != null && (host.equals("localhost") || host.equals("127.0.0.1")) && this.isSetBrowserStackLocal && !this.isSetBrowserStackLocalManaged) {
            log.info("To test against localhost and other locations behind your firewall, you need to run a BrowserStackLocal binary. You can ignore this if you have already started it, otherwise see browserstack.com/local-testing");
        }
        super.get(url);
    }
}

