/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.configuration.SecurityActions;
import org.jboss.arquillian.drone.spi.DroneConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMapper {
    private static final Logger log = Logger.getLogger(ConfigurationMapper.class.getName());
    private Map<String, String> nameValuePairs;

    private ConfigurationMapper() {
        this(Collections.emptyMap());
    }

    private ConfigurationMapper(Map<String, String> nameValuePairs) {
        this.nameValuePairs = nameValuePairs;
    }

    public static <T extends DroneConfiguration<T>> T fromArquillianDescriptor(ArquillianDescriptor descriptor, T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull((Object)descriptor, (String)"Descriptor must not be null");
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        ConfigurationMapper mapper = new ConfigurationMapper();
        mapper.setNameValuePairs(descriptor, descriptorQualifier, qualifierName);
        return mapper.mapFromArquillianDescriptor(configuration);
    }

    public static <T extends DroneConfiguration<T>> T fromSystemConfiguration(T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        ConfigurationMapper mapper = new ConfigurationMapper();
        return mapper.mapFromSystemProperties(configuration, descriptorQualifier, qualifierName);
    }

    private <T extends DroneConfiguration<T>> T mapFromArquillianDescriptor(T configuration) {
        List<Field> fields = SecurityActions.getAccessableFields(configuration.getClass());
        for (Field f : fields) {
            if (!this.nameValuePairs.containsKey(f.getName())) continue;
            try {
                f.set(configuration, this.convert(this.box(f.getType()), this.nameValuePairs.get(f.getName())));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
            }
        }
        return configuration;
    }

    private <T extends DroneConfiguration<T>> T mapFromSystemProperties(T configuration, String descriptorQualifier, String qualifierName) {
        String fullQualifiedPrefix;
        List<Field> fields = SecurityActions.getAccessableFields(configuration.getClass());
        Map<Field, String> fieldValuePairs = this.getFieldValuePairs(fields, fullQualifiedPrefix = "arquillian." + descriptorQualifier + "-" + qualifierName + ".");
        if (fieldValuePairs.isEmpty()) {
            String prefix = "arquillian." + descriptorQualifier + ".";
            fieldValuePairs = this.getFieldValuePairs(fields, prefix);
        }
        for (Map.Entry<Field, String> entry : fieldValuePairs.entrySet()) {
            try {
                entry.getKey().set(configuration, this.convert(this.box(entry.getKey().getType()), entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from System properties", e);
            }
        }
        return configuration;
    }

    private Map<Field, String> getFieldValuePairs(Collection<Field> fields, String prefix) {
        HashMap<Field, String> fieldValuePairs = new HashMap<Field, String>();
        for (Field f : fields) {
            String fieldName = this.keyTransform(new StringBuilder(prefix).append(f.getName()));
            String value = SecurityActions.getProperty(fieldName);
            if (value == null) continue;
            fieldValuePairs.put(f, value);
        }
        return fieldValuePairs;
    }

    private void setNameValuePairs(ArquillianDescriptor descriptor, String descriptorQualifier, String qualifierName) {
        String fullDescriptorQualifier = descriptorQualifier + "-" + qualifierName;
        ExtensionDef match = null;
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (fullDescriptorQualifier.equals(extension.getExtensionName())) {
                this.nameValuePairs = extension.getExtensionProperties();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Using <extension qualifier=\"" + extension.getExtensionName() + "\"> for Drone Configuration");
                }
                return;
            }
            if (!descriptorQualifier.equals(extension.getExtensionName())) continue;
            match = extension;
        }
        if (match != null) {
            this.nameValuePairs = match.getExtensionProperties();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using <extension qualifier=\"" + match.getExtensionName() + "\"> for Drone Configuration");
            }
        }
    }

    private String keyTransform(String fieldName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('.').append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String keyTransform(StringBuilder fieldName) {
        return this.keyTransform(fieldName.toString());
    }

    private Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    private <T> T convert(Class<T> clazz, String value) {
        if (String.class.equals(clazz)) {
            return clazz.cast(value);
        }
        if (Integer.class.equals(clazz)) {
            return clazz.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(clazz)) {
            return clazz.cast(Double.valueOf(value));
        }
        if (Long.class.equals(clazz)) {
            return clazz.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(clazz)) {
            return clazz.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + clazz.getName());
    }
}

