/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.configuration.SecurityActions;
import org.jboss.arquillian.drone.spi.DroneConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMapper {
    private static final Logger log = Logger.getLogger(ConfigurationMapper.class.getName());
    private static final String MAP_SUFFIX = "Map";

    private ConfigurationMapper() {
        throw new InstantiationError();
    }

    public static <T extends DroneConfiguration<T>> T fromArquillianDescriptor(ArquillianDescriptor descriptor, T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull((Object)descriptor, (String)"Descriptor must not be null");
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        Map<String, String> nameValuePairs = ConfigurationMapper.loadNameValuePairs(descriptor, descriptorQualifier, qualifierName);
        return ConfigurationMapper.mapFromNameValuePairs(configuration, nameValuePairs);
    }

    public static <T extends DroneConfiguration<T>> T fromSystemConfiguration(T configuration, Class<? extends Annotation> qualifier) {
        Validate.notNull(configuration, (String)"Configuration object must not be null");
        Validate.notNull(qualifier, (String)"Qualifier object must not be null");
        String descriptorQualifier = configuration.getConfigurationName();
        String qualifierName = qualifier.getSimpleName().toLowerCase();
        Map<String, String> nameValuePairs = ConfigurationMapper.loadNameValuePairs(descriptorQualifier, qualifierName);
        return ConfigurationMapper.mapFromNameValuePairs(configuration, nameValuePairs);
    }

    static <T extends DroneConfiguration<T>> T mapFromNameValuePairs(T configuration, Map<String, String> nameValuePairs) {
        String name;
        Map<String, Field> fields = SecurityActions.getAccessableFields(configuration.getClass());
        for (Map.Entry<String, String> nameValue : nameValuePairs.entrySet()) {
            name = nameValue.getKey();
            if (name.endsWith(MAP_SUFFIX) || !fields.containsKey(name)) continue;
            try {
                Field f = fields.get(name);
                if (f.getAnnotation(Deprecated.class) != null) {
                    log.log(Level.WARNING, "The property \"{0}\" used Arquillian \"{1}\" configuration is deprecated.", new Object[]{f.getName(), configuration.getConfigurationName()});
                }
                f.set(configuration, ConfigurationMapper.convert(ConfigurationMapper.box(f.getType()), nameValue.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
            }
        }
        for (Field f : fields.values()) {
            name = f.getName();
            if (!name.endsWith(MAP_SUFFIX) || !Map.class.isAssignableFrom(f.getType())) continue;
            Map<String, String> map = ConfigurationMapper.emulateMap(name.substring(0, name.lastIndexOf(MAP_SUFFIX)), nameValuePairs);
            try {
                if (f.getAnnotation(Deprecated.class) != null) {
                    log.log(Level.WARNING, "The property \"{0}\" used Arquillian \"{1}\" configuration is deprecated.", new Object[]{f.getName(), configuration.getConfigurationName()});
                }
                if (f.get(configuration) != null) {
                    ((Map)f.get(configuration)).putAll(map);
                    continue;
                }
                f.set(configuration, map);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not map Drone configuration(" + configuration.getConfigurationName() + ") for " + configuration.getClass().getName() + " from Arquillian Descriptor", e);
            }
        }
        return configuration;
    }

    static Map<String, String> emulateMap(String prefix, Map<String, String> nameValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> nameValueEntry : nameValuePairs.entrySet()) {
            String propertyName = nameValueEntry.getKey();
            if (!nameValueEntry.getKey().startsWith(prefix)) continue;
            StringBuilder key = new StringBuilder(propertyName.substring(prefix.length()));
            key.setCharAt(0, Character.toLowerCase(key.charAt(0)));
            map.put(ConfigurationMapper.keyTransform(key), nameValueEntry.getValue());
        }
        return map;
    }

    static Map<String, String> loadNameValuePairs(ArquillianDescriptor descriptor, String descriptorQualifier, String qualifierName) {
        String fullDescriptorQualifier = descriptorQualifier + "-" + qualifierName;
        ExtensionDef match = null;
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (fullDescriptorQualifier.equals(extension.getExtensionName())) {
                Map nameValuePairs = extension.getExtensionProperties();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Using <extension qualifier=\"" + extension.getExtensionName() + "\"> for Drone Configuration");
                }
                return nameValuePairs;
            }
            if (!descriptorQualifier.equals(extension.getExtensionName())) continue;
            match = extension;
        }
        if (match != null) {
            Map nameValuePairs = match.getExtensionProperties();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using <extension qualifier=\"" + match.getExtensionName() + "\"> for Drone Configuration");
            }
            return nameValuePairs;
        }
        return Collections.emptyMap();
    }

    static Map<String, String> loadNameValuePairs(String descriptorQualifier, String qualifierName) {
        String fullQualifiedPrefix = "arquillian." + descriptorQualifier + "." + qualifierName + ".";
        String qualifiedPrefix = "arquillian." + descriptorQualifier + ".";
        Map<String, String> candidates = SecurityActions.getProperties(fullQualifiedPrefix);
        if (candidates.isEmpty()) {
            candidates.putAll(SecurityActions.getProperties(qualifiedPrefix));
        }
        HashMap<String, String> nameValuePairs = new HashMap<String, String>(candidates.size());
        for (Map.Entry<String, String> entry : candidates.entrySet()) {
            String name = entry.getKey();
            name = name.contains(fullQualifiedPrefix) ? name.substring(fullQualifiedPrefix.length()) : name.substring(qualifiedPrefix.length());
            nameValuePairs.put(ConfigurationMapper.keyTransformReverse(name), entry.getValue());
        }
        return nameValuePairs;
    }

    static String keyTransform(String fieldName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('.').append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String keyTransform(StringBuilder fieldName) {
        return ConfigurationMapper.keyTransform(fieldName.toString());
    }

    static String keyTransformReverse(String propertyName) {
        StringBuilder sb = new StringBuilder();
        boolean upperCaseFlag = false;
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (c == '.') {
                upperCaseFlag = true;
                continue;
            }
            if (upperCaseFlag && Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                upperCaseFlag = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    static <T> T convert(Class<T> clazz, String value) {
        if (String.class.equals(clazz)) {
            return clazz.cast(value);
        }
        if (Integer.class.equals(clazz)) {
            return clazz.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(clazz)) {
            return clazz.cast(Double.valueOf(value));
        }
        if (Long.class.equals(clazz)) {
            return clazz.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(clazz)) {
            return clazz.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + clazz.getName());
    }
}

