/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration.legacy;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.configuration.legacy.CapabilityMapping;
import org.jboss.arquillian.drone.configuration.legacy.NegatingBooleanValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.StringValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;

public class LegacyPropertyToCapabilityMapper {
    private static final Logger log = Logger.getLogger(LegacyPropertyToCapabilityMapper.class.getName());
    private static final Map<String, DefaultCapabilityMapping> LEGACY_MAP = new HashMap<String, DefaultCapabilityMapping>();

    public static boolean isLegacy(String propertyName) {
        return LEGACY_MAP.containsKey(propertyName);
    }

    public static String remapKey(String propertyKey) {
        if (LegacyPropertyToCapabilityMapper.isLegacy(propertyKey)) {
            return LEGACY_MAP.get(propertyKey).remapKey(propertyKey);
        }
        return propertyKey;
    }

    public static String remapValue(String propertyKey, String propertyValue) {
        if (LegacyPropertyToCapabilityMapper.isLegacy(propertyValue)) {
            return LEGACY_MAP.get(propertyKey).remapValue(propertyValue);
        }
        return propertyValue;
    }

    static {
        LEGACY_MAP.put("firefoxBinary", new DefaultCapabilityMapping("firefox_binary"));
        LEGACY_MAP.put("firefoxProfile", new DefaultCapabilityMapping("firefox_profile"));
        LEGACY_MAP.put("chromeBinary", new DefaultCapabilityMapping("chrome.binary"));
        LEGACY_MAP.put("chromeSwitches", new DefaultCapabilityMapping("chrome.switches"));
        LEGACY_MAP.put("useJavaScript", new DefaultCapabilityMapping("javascriptEnabled"));
        LEGACY_MAP.put("operaArguments", new DefaultCapabilityMapping("opera.arguments"));
        LEGACY_MAP.put("operaAutostart", new DefaultCapabilityMapping("opera.autostart"));
        LEGACY_MAP.put("operaBinary", new DefaultCapabilityMapping("opera.binary"));
        LEGACY_MAP.put("operaDisplay", new DefaultCapabilityMapping("opera.display"));
        LEGACY_MAP.put("operaIdle", new DefaultCapabilityMapping("opera.idle"));
        LEGACY_MAP.put("operaLauncher", new DefaultCapabilityMapping("opera.launcher"));
        LEGACY_MAP.put("operaLoggingFile", new DefaultCapabilityMapping("opera.logging.file"));
        LEGACY_MAP.put("operaLoggingLevel", new DefaultCapabilityMapping("opera.logging.level"));
        LEGACY_MAP.put("operaQuit", new LoggingCapabilityMapping("opera.no_quit", NegatingBooleanValueMapper.INSTANCE, "\"operaQuit\" value was negated and stored as \"opera.no_quit\" capability"));
        LEGACY_MAP.put("operaRestart", new LoggingCapabilityMapping("opera.no_restart", NegatingBooleanValueMapper.INSTANCE, "\"operaRestart\" value was negated and stored as \"opera.no_restart\" capability"));
        LEGACY_MAP.put("operaPort", new DefaultCapabilityMapping("opera.port"));
        LEGACY_MAP.put("operaProduct", new DefaultCapabilityMapping("opera.product"));
        LEGACY_MAP.put("operaProfile", new DefaultCapabilityMapping("opera.profile"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingCapabilityMapping
    extends DefaultCapabilityMapping {
        private final String loggingMessage;

        public LoggingCapabilityMapping(String capabilityName, ValueMapper<?> mapper, String loggingMessage) {
            super(capabilityName, mapper);
            this.loggingMessage = loggingMessage;
        }

        @Override
        public String remapValue(String value) {
            log.log(Level.WARNING, this.loggingMessage);
            return super.remapValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultCapabilityMapping
    implements CapabilityMapping {
        private final String capabilityName;
        private final ValueMapper<?> mapper;

        public DefaultCapabilityMapping(String capabilityName) {
            this(capabilityName, StringValueMapper.INSTANCE);
        }

        public DefaultCapabilityMapping(String capabilityName, ValueMapper<?> mapper) {
            this.capabilityName = capabilityName;
            this.mapper = mapper;
        }

        @Override
        public String remapKey(String fieldName) {
            log.log(Level.WARNING, "Configuration property \"{0}\" is deprecated, please replace it with capability based property \"{1}\" instead.", new Object[]{fieldName, this.capabilityName});
            return this.capabilityName;
        }

        @Override
        public String remapValue(String value) {
            return this.mapper.transform(value).toString();
        }
    }
}

