/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.event.DroneConfigured;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.DroneRegistry;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.Instantiator;

public class DroneCreator {
    private static final Logger log = Logger.getLogger(DroneCreator.class.getName());
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Instance<DroneContext> droneContext;

    public void createWebTestBrowser(@Observes DroneConfigured event) {
        Field field = event.getInjected();
        Class<?> typeClass = field.getType();
        Class<? extends Annotation> qualifier = event.getQualifier();
        DroneConfiguration<?> configuration = event.getConfiguration();
        Instantiator<?, ?> instantiator = ((DroneRegistry)this.registry.get()).getInstantiatorFor(typeClass);
        if (instantiator == null) {
            throw new IllegalArgumentException("No instantiator was found for object of type " + typeClass.getName());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", with precedence " + instantiator.getPrecedence());
        }
        ((DroneContext)this.droneContext.get()).add(typeClass, qualifier, instantiator.createInstance(configuration));
    }
}

