/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneRegistry {
    private Map<Class<?>, RegistryValue> registry = new HashMap();

    public <T> Configurator<T, ?> getConfiguratorFor(Class<T> type) {
        RegistryValue value = this.registry.get(type);
        if (value != null) {
            return value.configurator;
        }
        return null;
    }

    public <T> Instantiator<T, ?> getInstantiatorFor(Class<T> key) {
        RegistryValue value = this.registry.get(key);
        if (value != null) {
            return value.instantiator;
        }
        return null;
    }

    public <T> Destructor<T> getDestructorFor(Class<T> key) {
        RegistryValue value = this.registry.get(key);
        if (value != null) {
            return value.destructor;
        }
        return null;
    }

    public DroneRegistry registerConfiguratorFor(Class<?> key, Configurator<?, ?> configurator) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.configurator = configurator;
        } else {
            this.registry.put(key, new RegistryValue().setConfigurator(configurator));
        }
        return this;
    }

    public DroneRegistry registerInstantiatorFor(Class<?> key, Instantiator<?, ?> value) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.instantiator = value;
        } else {
            this.registry.put(key, new RegistryValue().setInstantiator(value));
        }
        return this;
    }

    public DroneRegistry registerDestructorFor(Class<?> key, Destructor<?> value) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.destructor = value;
        } else {
            this.registry.put(key, new RegistryValue().setDestructor(value));
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistryValue {
        Configurator<?, ?> configurator;
        Instantiator<?, ?> instantiator;
        Destructor<?> destructor;

        private RegistryValue() {
        }

        public RegistryValue setConfigurator(Configurator<?, ?> configurator) {
            this.configurator = configurator;
            return this;
        }

        public RegistryValue setInstantiator(Instantiator<?, ?> instantiator) {
            this.instantiator = instantiator;
            return this;
        }

        public RegistryValue setDestructor(Destructor<?> destructor) {
            this.destructor = destructor;
            return this;
        }
    }
}

