/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.event.DroneConfigured;
import org.jboss.arquillian.drone.event.MethodDroneConfigured;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class DroneConfigurator {
    private static Logger log = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    @ClassScoped
    private InstanceProducer<DroneContext> droneContext;
    @Inject
    @TestScoped
    private InstanceProducer<MethodContext> droneMethodContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<DroneConfigured> afterConfiguration;
    @Inject
    private Event<MethodDroneConfigured> afterMethodConfiguration;

    public void configureDrone(@Observes BeforeClass event, DroneRegistry registry) {
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(event.getTestClass().getJavaClass(), Drone.class);
        if (fields.isEmpty()) {
            return;
        }
        this.droneContext.set((Object)new DroneContext());
        for (Field f : fields) {
            Class<?> typeClass = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Validate.notNull(this.arquillianDescriptor.get(), "ArquillianDescriptor should not be null");
            Configurator configurator = (Configurator)registry.getEntryFor(typeClass, Configurator.class);
            DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
            ((DroneContext)this.droneContext.get()).add(configuration.getClass(), qualifier, configuration);
            this.afterConfiguration.fire((Object)new DroneConfigured(f, qualifier, configuration));
        }
    }

    public void configureDrone(@Observes Before event, DroneRegistry registry) {
        Method method = event.getTestMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterTypes.length == 0) {
            return;
        }
        this.droneMethodContext.set((Object)new MethodContext());
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolving method " + method.getName() + " argument at position " + i);
            }
            Validate.notNull(this.arquillianDescriptor.get(), "ArquillianDescriptor should not be null");
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Configurator configurator = (Configurator)registry.getEntryFor(parameterTypes[i], Configurator.class);
            DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
            ((MethodContext)this.droneMethodContext.get()).add(configuration.getClass(), qualifier, configuration);
            this.afterMethodConfiguration.fire((Object)new MethodDroneConfigured(parameterTypes[i], qualifier, configuration));
        }
    }
}

