/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.DroneContextImpl;
import org.jboss.arquillian.drone.impl.InstanceOrCallableInstanceImpl;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneConfigured;
import org.jboss.arquillian.drone.spi.event.DroneConfigurationEvent;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class DroneConfigurator {
    private static Logger log = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    @ClassScoped
    private InstanceProducer<DroneContext> droneContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<DroneConfigurationEvent> droneConfigurationEvent;

    public void prepareDroneConfiguration(@Observes BeforeClass event, DroneRegistry registry) {
        this.droneContext.set((Object)new DroneContextImpl());
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(event.getTestClass().getJavaClass(), Drone.class);
        if (fields.isEmpty()) {
            return;
        }
        for (Field f : fields) {
            Class<?> droneType = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Validate.notNull(this.arquillianDescriptor.get(), "ArquillianDescriptor should not be null");
            Configurator configurator = (Configurator)registry.getEntryFor(droneType, Configurator.class);
            this.droneConfigurationEvent.fire((Object)new BeforeDroneConfigured(configurator, droneType, qualifier));
            DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
            InstanceOrCallableInstanceImpl droneConfiguration = new InstanceOrCallableInstanceImpl(configuration);
            ((DroneContext)this.droneContext.get()).add(configuration.getClass(), qualifier, (InstanceOrCallableInstance)droneConfiguration);
            this.droneConfigurationEvent.fire((Object)new AfterDroneConfigured((InstanceOrCallableInstance)droneConfiguration, droneType, qualifier));
        }
    }

    public void configureDrone(@Observes Before event, DroneRegistry registry) {
        Method method = event.getTestMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterTypes.length == 0) {
            return;
        }
        Validate.stateNotNull(this.droneContext.get(), "DroneContext should be available while working with method scoped instances");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolving method " + method.getName() + " argument at position " + i);
            }
            Validate.notNull(this.arquillianDescriptor.get(), "ArquillianDescriptor should not be null");
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Configurator configurator = (Configurator)registry.getEntryFor(parameterTypes[i], Configurator.class);
            this.droneConfigurationEvent.fire((Object)new BeforeDroneConfigured(configurator, parameterTypes[i], qualifier));
            DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
            InstanceOrCallableInstanceImpl droneConfiguration = new InstanceOrCallableInstanceImpl(configuration);
            ((DroneContext)this.droneContext.get()).add(configuration.getClass(), qualifier, (InstanceOrCallableInstance)droneConfiguration);
            this.droneConfigurationEvent.fire((Object)new AfterDroneConfigured((InstanceOrCallableInstance)droneConfiguration, parameterTypes[i], qualifier));
        }
    }
}

