/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;

public class DroneInstanceCreator {
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Inject
    private Instance<DroneContext> context;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void createDroneInstance(@Observes(precedence=0x7FFFFFFF) BeforeDroneInstantiated event) {
        InstanceOrCallableInstance union = event.getInstanceCallable();
        Class droneType = event.getDroneType();
        Class qualifier = event.getQualifier();
        try {
            Object browser = executorService.submit(union.asCallableInstance(droneType)).get(5L, TimeUnit.SECONDS);
            union.set(browser);
            this.droneLifecycleEvent.fire((Object)new AfterDroneInstantiated(union, droneType, qualifier));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance within 5" + (Object)((Object)TimeUnit.SECONDS), e);
        }
    }
}

