/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(DroneTestEnricher.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void enrich(Object testCase) {
        List<Field> droneEnrichements = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), Drone.class);
        if (!droneEnrichements.isEmpty()) {
            this.droneEnrichement(testCase, droneEnrichements);
        }
    }

    public Object[] resolve(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] resolution = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolving method " + method.getName() + " argument at position " + i);
            }
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Object value = this.getDroneInstance(parameterTypes[i], qualifier);
            Validate.notNull(value, "Retrieved a null from context, which is not a valid Drone browser object");
            resolution[i] = value;
        }
        return resolution;
    }

    private void droneEnrichement(Object testCase, List<Field> fields) {
        try {
            for (Field f : fields) {
                if (f.get(testCase) != null) {
                    return;
                }
                Class<?> typeClass = f.getType();
                Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
                Object value = this.getDroneInstance(typeClass, qualifier);
                f.set(testCase, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not enrich test with Drone members", e);
        }
    }

    private <T> T getDroneInstance(Class<T> type, Class<? extends Annotation> qualifier) {
        Validate.stateNotNull(this.droneContext.get(), "Drone Context must not be null");
        InstanceOrCallableInstance union = ((DroneContext)this.droneContext.get()).get(type, qualifier);
        Validate.notNull(union, "Retrieved a null from context, which is not a valid Drone browser object");
        if (union.isInstanceCallable()) {
            this.droneLifecycleEvent.fire((Object)new BeforeDroneInstantiated(union, type, qualifier));
        }
        return (T)union.asInstance(type);
    }
}

