/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.impl.DroneConfigurator;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;

public class DroneInstanceCreator {
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Inject
    private Instance<DroneContext> context;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void createDroneInstance(@Observes(precedence=-2147483648) BeforeDroneInstantiated event) {
        InstanceOrCallableInstance union = event.getInstanceCallable();
        Class droneType = event.getDroneType();
        Class qualifier = event.getQualifier();
        InstanceOrCallableInstance globalConfigurationUnion = ((DroneContext)this.context.get()).get(DroneConfigurator.GlobalDroneConfiguration.class, Default.class);
        Validate.stateNotNull(globalConfigurationUnion, "Drone global configuration should be available in the context");
        DroneConfigurator.GlobalDroneConfiguration globalDroneConfiguration = (DroneConfigurator.GlobalDroneConfiguration)globalConfigurationUnion.asInstance(DroneConfigurator.GlobalDroneConfiguration.class);
        int timeout = globalDroneConfiguration.getInstantiationTimeoutInSeconds();
        try {
            Object browser = null;
            browser = timeout > 0 ? executorService.submit(union.asCallableInstance(droneType)).get(timeout, TimeUnit.SECONDS) : executorService.submit(union.asCallableInstance(droneType)).get();
            union.set(browser);
            this.droneLifecycleEvent.fire((Object)new AfterDroneInstantiated(union, droneType, qualifier));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance, thread interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new RuntimeException(cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance within " + timeout + " " + TimeUnit.SECONDS.toString().toLowerCase(), e);
        }
    }
}

