/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(DroneTestEnricher.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void enrich(Object testCase) {
        List<Field> droneEnrichements = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), Drone.class);
        for (Field f : droneEnrichements) {
            if (SecurityActions.getFieldValue(testCase, f) != null) {
                log.log(Level.FINER, "Skipped injection of field {0}", f.getName());
                continue;
            }
            Class<?> typeClass = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            log.log(Level.FINE, "Injecting @Drone for field {0} @{1} {2}", new Object[]{typeClass.getSimpleName(), qualifier.getSimpleName(), f.getName()});
            Object value = this.getDroneInstance(DroneScope.CLASS_SCOPED, typeClass, qualifier);
            Validate.notNull(value, "Retrieved a null from Drone Context, which is not a valid Drone browser object");
            SecurityActions.setFieldValue(testCase, f, value);
        }
    }

    public Object[] resolve(Method method) {
        Map<Integer, Annotation[]> droneEnrichements = SecurityActions.getParametersWithAnnotation(method, Drone.class);
        Class<?>[] parameters = method.getParameterTypes();
        Object[] resolution = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> droneType = parameters[i];
            if (!droneEnrichements.containsKey(i)) continue;
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(droneEnrichements.get(i));
            log.log(Level.FINE, "Injecting @Drone for method {0}, argument {1} @{2} ", new Object[]{method.getName(), droneType.getSimpleName(), qualifier.getSimpleName()});
            Object value = this.getDroneInstance(DroneScope.METHOD_SCOPED, droneType, qualifier);
            Validate.notNull(value, "Retrieved a null from Drone Context, which is not a valid Drone browser object");
            resolution[i] = value;
        }
        return resolution;
    }

    private <T> T getDroneInstance(DroneScope scope, Class<T> type, Class<? extends Annotation> qualifier) {
        Validate.stateNotNull(this.droneContext.get(), "Drone Context must not be null");
        InstanceOrCallableInstance union = scope.getScopedDroneInstance((DroneContext)this.droneContext.get(), type, qualifier);
        Validate.notNull(union, "Retrieved a null from context, which is not a valid Drone browser object");
        if (union.isInstanceCallable()) {
            this.droneLifecycleEvent.fire((Object)new BeforeDroneInstantiated(union, type, qualifier));
        }
        return (T)union.asInstance(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DroneScope {
        CLASS_SCOPED{

            @Override
            public <T> InstanceOrCallableInstance getScopedDroneInstance(DroneContext context, Class<T> type, Class<? extends Annotation> qualifier) {
                InstanceOrCallableInstance droneInstance = null;
                InstanceOrCallableInstance candidate = null;
                LinkedList<InstanceOrCallableInstance> temporaryStorage = new LinkedList<InstanceOrCallableInstance>();
                while ((candidate = context.get(type, qualifier)) != null) {
                    temporaryStorage.add(candidate);
                    context.remove(type, qualifier);
                    droneInstance = candidate;
                }
                for (int i = temporaryStorage.size() - 1; i >= 0; --i) {
                    context.add(type, qualifier, (InstanceOrCallableInstance)temporaryStorage.get(i));
                }
                return droneInstance;
            }
        }
        ,
        METHOD_SCOPED{

            @Override
            public <T> InstanceOrCallableInstance getScopedDroneInstance(DroneContext context, Class<T> type, Class<? extends Annotation> qualifier) {
                return context.get(type, qualifier);
            }
        };


        public abstract <T> InstanceOrCallableInstance getScopedDroneInstance(DroneContext var1, Class<T> var2, Class<? extends Annotation> var3);
    }
}

