/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.impl.PrecedenceComparator;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneInstanceEnhancer;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneDeenhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDeenhanced;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.BeforeDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.DroneEnhancementEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneEnhancer {
    private static final Logger log = Logger.getLogger(DroneEnhancer.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<DroneEnhancementEvent> droneEnhancementEvent;

    public <T> void enhanceDrone(@Observes AfterDroneInstantiated event, DroneContext context) {
        ArrayList enhancers = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(DroneInstanceEnhancer.class));
        Collections.sort(enhancers, PrecedenceComparator.getInstance());
        DronePoint dronePoint = event.getDronePoint();
        Object drone = context.get(dronePoint).getInstance();
        for (DroneInstanceEnhancer enhancer : enhancers) {
            CompatibilityInstanceOrCallableInstance instanceOrCallableInstance;
            if (!enhancer.canEnhance((InstanceOrCallableInstance)(instanceOrCallableInstance = new CompatibilityInstanceOrCallableInstance(drone)), dronePoint.getDroneType(), dronePoint.getQualifier())) continue;
            log.log(Level.FINE, "Enhancing Drone {0} using enhancer {2} with precedence {3}", new Object[]{dronePoint, enhancer.getClass().getName(), enhancer.getPrecedence()});
            this.droneEnhancementEvent.fire((Object)new BeforeDroneEnhanced(enhancer, dronePoint));
            DroneInstanceEnhancer supportedEnhancer = enhancer;
            Object enhancedDrone = supportedEnhancer.enhance(drone, dronePoint.getQualifier());
            if (enhancedDrone == null) {
                throw new IllegalStateException("Enhanced drone cannot be null!");
            }
            if (enhancedDrone != drone) {
                context.get(dronePoint).setFutureInstance(new ConstantValueCachingCallable<Object>(enhancedDrone));
                drone = enhancedDrone;
            }
            this.droneEnhancementEvent.fire((Object)new AfterDroneEnhanced(dronePoint));
        }
    }

    public <T> void deenhanceDrone(@Observes BeforeDroneDestroyed event, DroneContext context) {
        ArrayList enhancers = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(DroneInstanceEnhancer.class));
        Collections.sort(enhancers, PrecedenceComparator.getReversedOrder());
        DronePoint dronePoint = event.getDronePoint();
        Object drone = context.get(dronePoint).getInstance();
        for (DroneInstanceEnhancer enhancer : enhancers) {
            CompatibilityInstanceOrCallableInstance instanceOrCallableInstance;
            if (!enhancer.canEnhance((InstanceOrCallableInstance)(instanceOrCallableInstance = new CompatibilityInstanceOrCallableInstance(drone)), dronePoint.getDroneType(), dronePoint.getQualifier())) continue;
            log.log(Level.FINER, "Deenhancing {0} using enhancer {1} with precedence {2}", new Object[]{dronePoint, enhancer.getClass().getName(), enhancer.getPrecedence()});
            this.droneEnhancementEvent.fire((Object)new BeforeDroneDeenhanced(enhancer, dronePoint));
            DroneInstanceEnhancer supportedEnhancer = enhancer;
            Object deenhancedDrone = supportedEnhancer.deenhance(drone, dronePoint.getQualifier());
            if (deenhancedDrone == null) {
                throw new IllegalStateException("Deenahnced drone cannot be null!");
            }
            if (deenhancedDrone != drone) {
                context.get(dronePoint).setFutureInstance(new ConstantValueCachingCallable<Object>(deenhancedDrone));
                drone = deenhancedDrone;
            }
            this.droneEnhancementEvent.fire((Object)new AfterDroneDeenhanced(dronePoint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompatibilityInstanceOrCallableInstance
    implements InstanceOrCallableInstance {
        private final Object value;

        public CompatibilityInstanceOrCallableInstance(Object value) {
            this.value = value;
        }

        public InstanceOrCallableInstance set(Object value) throws IllegalArgumentException {
            throw new UnsupportedOperationException("CompatibilityInstanceOrCallableInstance is read-only!");
        }

        public boolean isInstance() {
            return true;
        }

        public boolean isInstanceCallable() {
            return false;
        }

        public <T> T asInstance(Class<T> type) throws IllegalStateException {
            return (T)this.value;
        }

        public <T> Callable<T> asCallableInstance(Class<T> type) throws IllegalStateException {
            throw new UnsupportedOperationException("CompatibilityInstanceOrCallableInstance only provides instance!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstantValueCachingCallable<V>
    implements CachingCallable<V> {
        private final V value;

        public ConstantValueCachingCallable(V value) {
            this.value = value;
        }

        public boolean isValueCached() {
            return true;
        }

        public V call() throws Exception {
            return this.value;
        }
    }
}

