/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.DronePoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DronePointImpl<DRONE>
implements DronePoint<DRONE> {
    private final Class<DRONE> droneClass;
    private final Annotation[] annotations;
    private final DronePoint.Lifecycle lifecycle;

    public DronePointImpl(Class<DRONE> droneClass, DronePoint.Lifecycle lifecycle, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (annotation != null) continue;
            throw new IllegalArgumentException("Annotation cannot be null!");
        }
        this.droneClass = droneClass;
        this.annotations = annotations;
        this.lifecycle = lifecycle;
        Arrays.sort(this.annotations, new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public Class<DRONE> getDroneType() {
        return this.droneClass;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public DronePoint.Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Deprecated
    public Class<? extends Annotation> getQualifier() {
        Class<? extends Annotation> qualifier = SecurityActions.getQualifier(this.annotations);
        return qualifier != null ? qualifier : Default.class;
    }

    public boolean conformsTo(Class<?> droneClass) {
        if (droneClass == null) {
            return true;
        }
        return droneClass.isAssignableFrom(this.droneClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DronePointImpl that = (DronePointImpl)o;
        if (!Arrays.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (this.droneClass != null ? !this.droneClass.equals(that.droneClass) : that.droneClass != null) {
            return false;
        }
        return this.lifecycle == that.lifecycle;
    }

    public int hashCode() {
        int result = this.droneClass != null ? this.droneClass.hashCode() : 0;
        result = 31 * result + (this.annotations != null ? Arrays.hashCode(this.annotations) : 0);
        result = 31 * result + (this.lifecycle != null ? this.lifecycle.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DronePointImpl{droneClass=" + this.droneClass + ", annotations=" + Arrays.toString(this.annotations) + ", lifecycle=" + this.lifecycle + '}';
    }
}

